package com.xebialabs.xlrelease.versioning.scm

import com.xebialabs.xlrelease.domain.scm.connector.BaseScmConnectorConfig
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.scm.connector._
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo
import com.xebialabs.xlrelease.service.{ConfigurationVariableService, ReleaseService, UserProfileService}
import com.xebialabs.xlrelease.versioning.TemplateVersioningException
import org.apache.commons.codec.digest.DigestUtils
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.util.Using

@Component
class ScmTemplateStorageService @Autowired()(scmConnectorService: ScmConnectorService,
                                             scmTemplateToBlobsConverter: ScmTemplateToBlobsConverter,
                                             releaseService: ReleaseService,
                                             userProfileService: UserProfileService,
                                             configurationVariableService: ConfigurationVariableService
                                            ) {

  def createNewVersion(templateId: String, version: String, description: String, user: String): String = {
    val template = releaseService.findById(templateId)
    if (template.isWorkflow) {
      throw TemplateVersioningException("Template version control is not supported for workflows")
    }
    val scmConfiguration = scmConnectorService.findScmConnectorConfig(Ids.findFolderId(templateId))
    scmConfiguration match {
      case c: BaseScmConnectorConfig => configurationVariableService.resolve(c)
      case _ => ()
    }
    Using.resource(scmConfiguration.getConnector) { scmConnector =>
      val (templateFilePath, blobs) = scmTemplateToBlobsConverter.convertTemplate(template)
      val identifier = scmConnector.getIdentifier(templateFilePath)
      val commitInfo = ValidatedCommitInfo.create(version, description, s"xlr/${DigestUtils.sha1Hex(identifier)}").get
      val userProfile = userProfileService.findByUsername(user)
      scmConnector.createNewVersion(blobs, commitInfo, userProfile).get
      commitInfo.tag.refName
    }
  }
}
