package com.xebialabs.xlrelease.versioning.templates.configuration

import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.{TemplateVersioningSettings, VersioningSettings}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.SmartLifecycle
import org.springframework.context.annotation.Configuration
import org.springframework.scheduling.annotation.{EnableScheduling, Scheduled}

@Configuration
@EnableScheduling
class TemplateVersioningSettingsConfiguration @Autowired()(configurationRepository: ConfigurationRepository) extends SmartLifecycle {

  private var running: Boolean = false

  @Scheduled(initialDelay = 0, fixedDelay = 60000)
  def refreshTemplateVersioningConfiguration(): Unit = {
    if (running) {
      val ci: TemplateVersioningSettings = configurationRepository.read(TemplateVersioningSettings.TEMPLATE_VERSIONING_ID)
      VersioningSettings.automaticChangesEnabled = ci.enableAutomatedVersioning
    }
  }

  override def start(): Unit = {
    running = true
    refreshTemplateVersioningConfiguration()
  }

  override def stop(): Unit = {
    running = false
    // do not call template versioning
  }

  override def isRunning: Boolean = running

  override def getPhase: Int = 2
}
