/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.scm;

import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.scm.connector.BaseScmConnectorConfig;
import com.xebialabs.xlrelease.domain.scm.connector.ScmConnectorConfig;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.scm.connector.ScmBlobs;
import com.xebialabs.xlrelease.scm.connector.ScmConnectorService;
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo;
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo$;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException$;
import com.xebialabs.xlrelease.versioning.scm.ScmTemplateToBlobsConverter;
import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.util.Using;
import scala.util.Using$;

@Component
@ScalaSignature(bytes="\u0006\u0005)4A\u0001C\u0005\u0001)!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0011!A\u0003A!A!\u0002\u0013I\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u0011M\u0002!\u0011!Q\u0001\nQBQa\u000e\u0001\u0005\u0002aBQA\u0014\u0001\u0005\u0002=\u0013\u0011dU2n)\u0016l\u0007\u000f\\1uKN#xN]1hKN+'O^5dK*\u0011!bC\u0001\u0004g\u000el'B\u0001\u0007\u000e\u0003)1XM]:j_:Lgn\u001a\u0006\u0003\u001d=\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005A\t\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005\u0011\u0012aA2p[\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u0006\u00192oY7D_:tWm\u0019;peN+'O^5dKB\u0011Q$I\u0007\u0002=)\u0011q\u0004I\u0001\nG>tg.Z2u_JT!AC\u0007\n\u0005\tr\"aE*d[\u000e{gN\\3di>\u00148+\u001a:wS\u000e,\u0017aG:d[R+W\u000e\u001d7bi\u0016$vN\u00117pEN\u001cuN\u001c<feR,'\u000f\u0005\u0002&M5\t\u0011\"\u0003\u0002(\u0013\tY2kY7UK6\u0004H.\u0019;f)>\u0014En\u001c2t\u0007>tg/\u001a:uKJ\faB]3mK\u0006\u001cXmU3sm&\u001cW\r\u0005\u0002+[5\t1F\u0003\u0002-\u001b\u000591/\u001a:wS\u000e,\u0017B\u0001\u0018,\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016\f!#^:feB\u0013xNZ5mKN+'O^5dKB\u0011!&M\u0005\u0003e-\u0012!#V:feB\u0013xNZ5mKN+'O^5dK\u0006a2m\u001c8gS\u001e,(/\u0019;j_:4\u0016M]5bE2,7+\u001a:wS\u000e,\u0007C\u0001\u00166\u0013\t14F\u0001\u000fD_:4\u0017nZ;sCRLwN\u001c,be&\f'\r\\3TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0019I$h\u000f\u001f>}A\u0011Q\u0005\u0001\u0005\u00067\u0019\u0001\r\u0001\b\u0005\u0006G\u0019\u0001\r\u0001\n\u0005\u0006Q\u0019\u0001\r!\u000b\u0005\u0006_\u0019\u0001\r\u0001\r\u0005\u0006g\u0019\u0001\r\u0001\u000e\u0015\u0003\r\u0001\u0003\"!\u0011'\u000e\u0003\tS!a\u0011#\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002F\r\u00069a-Y2u_JL(BA$I\u0003\u0015\u0011W-\u00198t\u0015\tI%*A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005Y\u0015aA8sO&\u0011QJ\u0011\u0002\n\u0003V$xn^5sK\u0012\f\u0001c\u0019:fCR,g*Z<WKJ\u001c\u0018n\u001c8\u0015\u000bA[VlX1\u0011\u0005ECfB\u0001*W!\t\u0019v#D\u0001U\u0015\t)6#\u0001\u0004=e>|GOP\u0005\u0003/^\ta\u0001\u0015:fI\u00164\u0017BA-[\u0005\u0019\u0019FO]5oO*\u0011qk\u0006\u0005\u00069\u001e\u0001\r\u0001U\u0001\u000bi\u0016l\u0007\u000f\\1uK&#\u0007\"\u00020\b\u0001\u0004\u0001\u0016a\u0002<feNLwN\u001c\u0005\u0006A\u001e\u0001\r\u0001U\u0001\fI\u0016\u001c8M]5qi&|g\u000eC\u0003c\u000f\u0001\u0007\u0001+\u0001\u0003vg\u0016\u0014\bF\u0001\u0001e!\t)\u0007.D\u0001g\u0015\t9\u0007*\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016L!!\u001b4\u0003\u0013\r{W\u000e]8oK:$\b")
public class ScmTemplateStorageService {
    private final ScmConnectorService scmConnectorService;
    private final ScmTemplateToBlobsConverter scmTemplateToBlobsConverter;
    private final ReleaseService releaseService;
    private final UserProfileService userProfileService;
    private final ConfigurationVariableService configurationVariableService;

    public String createNewVersion(String templateId, String version, String description, String user) {
        ScmConnectorConfig scmConfiguration;
        Release template;
        block1: {
            template = this.releaseService.findById(templateId);
            if (template.isWorkflow()) {
                throw new TemplateVersioningException("Template version control is not supported for workflows", TemplateVersioningException$.MODULE$.apply$default$2(), TemplateVersioningException$.MODULE$.apply$default$3());
            }
            scmConfiguration = this.scmConnectorService.findScmConnectorConfig(Ids.findFolderId((String)templateId));
            ScmConnectorConfig scmConnectorConfig = scmConfiguration;
            if (!(scmConnectorConfig instanceof BaseScmConnectorConfig)) break block1;
            BaseScmConnectorConfig baseScmConnectorConfig = (BaseScmConnectorConfig)scmConnectorConfig;
            this.configurationVariableService.resolve((Configuration)baseScmConnectorConfig);
        }
        return (String)Using$.MODULE$.resource((Object)scmConfiguration.getConnector(), (Function1 & Serializable)scmConnector -> {
            Tuple2<String, ScmBlobs> tuple2 = $this.scmTemplateToBlobsConverter.convertTemplate(template);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String templateFilePath = (String)tuple2._1();
            ScmBlobs blobs = (ScmBlobs)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)templateFilePath, (Object)blobs);
            String templateFilePath2 = (String)tuple22._1();
            ScmBlobs blobs2 = (ScmBlobs)tuple22._2();
            String identifier = scmConnector.getIdentifier(templateFilePath2);
            ValidatedCommitInfo commitInfo = (ValidatedCommitInfo)ValidatedCommitInfo$.MODULE$.create(version, description, "xlr/" + DigestUtils.sha1Hex((String)identifier)).get();
            UserProfile userProfile = $this.userProfileService.findByUsername(user);
            scmConnector.createNewVersion(blobs2, commitInfo, userProfile).get();
            return commitInfo.tag().refName();
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Autowired
    public ScmTemplateStorageService(ScmConnectorService scmConnectorService, ScmTemplateToBlobsConverter scmTemplateToBlobsConverter, ReleaseService releaseService, UserProfileService userProfileService, ConfigurationVariableService configurationVariableService) {
        this.scmConnectorService = scmConnectorService;
        this.scmTemplateToBlobsConverter = scmTemplateToBlobsConverter;
        this.releaseService = releaseService;
        this.userProfileService = userProfileService;
        this.configurationVariableService = configurationVariableService;
    }
}

