package com.xebialabs.xlrelease.versioning.templates.actors.extensions

import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages.ExtensionCommand
import com.xebialabs.xlrelease.actors.extension.ActorExtensionHandlerFactory
import com.xebialabs.xlrelease.actors.{ActorSystemHolder, ReleaseExecutionActor}
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.versioning.templates.TemplateStorageService
import com.xebialabs.xlrelease.versioning.templates.actors.extensions.TemplateVersionExtensionActorMessages.{NewTemplateVersion, RestoreRevision}
import grizzled.slf4j.Logging
import org.apache.pekko.actor.Actor.Receive
import org.apache.pekko.actor.{Actor, ActorRef}
import org.springframework.stereotype.Component

object TemplateVersionExtensionActorMessages {

  case class NewTemplateVersion(name: String, description: String, author: String) extends ExtensionCommand

  case class RestoreRevision(revisionId: Int) extends ExtensionCommand

}

@Component
class TemplateVersionActorExtensionHandlerFactory(val actorSystemHolder: ActorSystemHolder,
                                                  templateStorageService: TemplateStorageService,
                                                  implicit val xlrConfig: XlrConfig)
  extends ActorExtensionHandlerFactory
    with Logging {

  override def supports(clazz: Class[_ <: Actor]): Boolean = classOf[ReleaseExecutionActor].isAssignableFrom(clazz)

  override def getHandler(self: ActorRef, sender: () => ActorRef, release: => Release): Receive = {
    case NewTemplateVersion(name, description, author) => replyOrFail(sender) {
      templateStorageService.saveVersion(release.getId, author, name, description)
    }
    case RestoreRevision(revisionId) => replyOrFail(sender) {
      templateStorageService.restore(release.getId, revisionId)
    }
  }

}
