package com.xebialabs.xlrelease.versioning.templates.configuration.domain

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(root = CONFIGURATION, versioned = false, label = "Template Version control (Not recommended)", description = "Release will use these settings to enable automatic versioning of templates. Settings will take effect after 1 minute. Note: This feature is deprecated and has been superseded by Folder versioning.")
class TemplateVersioningSettings extends FeatureSettings {

  @BeanProperty
  @XLProperty(defaultValue = "false",
    label = "Enable template versioning",
    description = "When checked, Version control tab will be displayed in templates.",
    category = "input"
  )
  var enabled: Boolean = _

  @BeanProperty
  @XLProperty(defaultValue = "false",
    label = "Enable automatic saving of a new version after template changes",
    category = "input")
  var enableAutomatedVersioning: Boolean = _

  @BeanProperty
  @XLProperty(defaultValue = "template", hidden = true)
  var displayIcon: String = _

  @BeanProperty
  @XLProperty(defaultValue = "general-settings", hidden = true)
  var displayPage: String = _

  @BeanProperty
  @XLProperty(defaultValue = "70", hidden = true)
  var weight: Integer = _

  @BeanProperty
  @XLProperty(defaultValue = "true", hidden = true,
    label = "Note: Template version control feature is being deprecated. It is replaced by 'GitOps enabled version control'.")
  var deprecated: Boolean = _

}

object TemplateVersioningSettings {
  val TEMPLATE_VERSIONING_ID: String = FeatureSettings.BASE_FEATURE_ID + "TemplateVersioningSettings"
}

object VersioningSettings {
  var automaticChangesEnabled: Boolean = false
}
