package com.xebialabs.xlrelease.versioning.templates.upgrade

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.TemplateVersioningSchema.TEMPLATE_REVISIONS
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

@Component
class XLRelease243EnableTemplateVersioningUpgrade @Autowired()(@Qualifier("xlrRepositoryJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                                               @Qualifier("xlrRepositorySqlDialect") implicit val dialect: Dialect,
                                                               configurationRepository: ConfigurationRepository)
  extends Upgrade with PersistenceSupport with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "24.3.0#3")

  override def doUpgrade(): Boolean = {
    updateTemplateVersioningSettingsId()
    if (someTemplateRevisionExists) {
      logger.info("Template versioning is already used, enabling feature")
      enableTemplateVersioningFeature()
    } else {
      logger.info("Template versioning is not used, no action required")
    }
    true
  }

  private def updateTemplateVersioningSettingsId(): Unit = {
    val oldTemplateVersioningSettingsId = "Configuration/settings/TemplateVersioningSettings"
    if (configurationRepository.exists(oldTemplateVersioningSettingsId)) {
      logger.info(s"Updating template versioning settings id from $oldTemplateVersioningSettingsId to ${TemplateVersioningSettings.TEMPLATE_VERSIONING_ID}")

      val oldTemplateVersioningSettings: TemplateVersioningSettings = configurationRepository.read(oldTemplateVersioningSettingsId)
      configurationRepository.delete(oldTemplateVersioningSettingsId)

      oldTemplateVersioningSettings.setId(TemplateVersioningSettings.TEMPLATE_VERSIONING_ID)
      configurationRepository.create(oldTemplateVersioningSettings)
    }
  }


  private def someTemplateRevisionExists: Boolean = {
    val query = s"SELECT COUNT(*) FROM ${TEMPLATE_REVISIONS.TABLE}"
    val count = jdbcTemplate.queryForObject(query, classOf[Integer])
    count > 0
  }

  private def enableTemplateVersioningFeature(): Unit = {
    val templateVersioningSettings: TemplateVersioningSettings = configurationRepository.read(TemplateVersioningSettings.TEMPLATE_VERSIONING_ID)
    templateVersioningSettings.setEnabled(true)
    configurationRepository.update(templateVersioningSettings)
  }

}
