/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.templates;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.dsl.service.DslExporter;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException;
import com.xebialabs.xlrelease.versioning.scm.ScmTemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.CreateVersionResponse;
import com.xebialabs.xlrelease.versioning.templates.CreateVersionResponse$;
import com.xebialabs.xlrelease.versioning.templates.TemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.actors.extensions.TemplateVersionExtensionActorMessages;
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings;
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings$;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevision;
import com.xebialabs.xlrelease.versioning.templates.views.TemplateContentAndPrevious;
import com.xebialabs.xlrelease.versioning.templates.views.VersionView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.util.Try;
import scala.util.Try$;

@Path(value="/versioning")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0001\tMf\u0001B\u0001\u0003\u00015\u0011!\u0004V3na2\fG/\u001a,feNLwN\\5oOJ+7o\\;sG\u0016T!a\u0001\u0003\u0002\u0013Q,W\u000e\u001d7bi\u0016\u001c(BA\u0003\u0007\u0003)1XM]:j_:Lgn\u001a\u0006\u0003\u000f!\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\u000e\u000e\u0003YQ!a\u0006\r\u0002\u000bMdg\r\u000e6\u000b\u0003e\t\u0001b\u001a:jujdW\rZ\u0005\u00037Y\u0011q\u0001T8hO&tw\r\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003-!7\u000f\\#ya>\u0014H/\u001a:\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013aB:feZL7-\u001a\u0006\u0003G\u0019\t1\u0001Z:m\u0013\t)\u0003EA\u0006Eg2,\u0005\u0010]8si\u0016\u0014\b\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u00025Q,W\u000e\u001d7bi\u0016\u0014VM^5tS>t'+\u001a9pg&$xN]=\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-\u0012\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011QF\u000b\u0002\u001b)\u0016l\u0007\u000f\\1uKJ+g/[:j_:\u0014V\r]8tSR|'/\u001f\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u00051B/Z7qY\u0006$Xm\u0015;pe\u0006<WmU3sm&\u001cW\r\u0005\u00022e5\t!!\u0003\u00024\u0005\t1B+Z7qY\u0006$Xm\u0015;pe\u0006<WmU3sm&\u001cW\r\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0003M\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f!\t9$(D\u00019\u0015\tId!\u0001\u0004bGR|'o]\u0005\u0003wa\u00121CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016D\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\u0012a\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014\bCA C\u001b\u0005\u0001%BA!\u0007\u0003!\u0019XmY;sSRL\u0018BA\"A\u0005E\u0001VM]7jgNLwN\\\"iK\u000e\\WM\u001d\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\u0006q!/\u001a7fCN,7+\u001a:wS\u000e,\u0007CA$J\u001b\u0005A%BA\u0011\u0007\u0013\tQ\u0005J\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\t\u00111\u0003!\u0011!Q\u0001\n5\u000bqcY8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u00059\u0003V\"A(\u000b\u0005-2\u0011BA)P\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0003]!X-\u001c9mCR,7\u000b^8sC\u001e,G*[:uK:,'\u000f\u0005\u0002V16\taK\u0003\u0002X\t\u0005\u00191oY7\n\u0005e3&!G*d[R+W\u000e\u001d7bi\u0016\u001cFo\u001c:bO\u0016\u001cVM\u001d<jG\u0016DQa\u0017\u0001\u0005\u0002q\u000ba\u0001P5oSRtD#C/_?\u0002\f'm\u00193f!\t\t\u0004\u0001C\u0003\u001e5\u0002\u0007a\u0004C\u0003(5\u0002\u0007\u0001\u0006C\u000305\u0002\u0007\u0001\u0007C\u000365\u0002\u0007a\u0007C\u0003>5\u0002\u0007a\bC\u0003F5\u0002\u0007a\tC\u0003M5\u0002\u0007Q\nC\u0003T5\u0002\u0007A\u000b\u000b\u0002[OB\u0011\u0001n]\u0007\u0002S*\u0011!n[\u0001\u000bC:tw\u000e^1uS>t'B\u00017n\u0003\u001d1\u0017m\u0019;pefT!A\\8\u0002\u000b\t,\u0017M\\:\u000b\u0005A\f\u0018aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003I\f1a\u001c:h\u0013\t!\u0018NA\u0005BkR|w/\u001b:fI\")a\u000f\u0001C\u0001o\u0006qr-\u001a;UK6\u0004H.\u0019;f-\u0016\u00148/[8o_&twmU3ui&twm]\u000b\u0002qB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\u0007I>l\u0017-\u001b8\u000b\u0005u\u0014\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0002\u0000u\nQB+Z7qY\u0006$XMV3sg&|g.\u001b8h'\u0016$H/\u001b8hg\":Q/a\u0001\u0002\u0018\u0005e\u0001\u0003BA\u0003\u0003'i!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0003eNTA!!\u0004\u0002\u0010\u0005\u0011qo\u001d\u0006\u0003\u0003#\tQA[1wCbLA!!\u0006\u0002\b\t!\u0001+\u0019;i\u0003\u00151\u0018\r\\;fC\t\tY\"A\u00050g\u0016$H/\u001b8hg\"\u001aQ/a\b\u0011\t\u0005\u0015\u0011\u0011E\u0005\u0005\u0003G\t9AA\u0002H\u000bRCq!a\n\u0001\t\u0003\tI#\u0001\u0007hKR\u0014VM^5tS>t7\u000f\u0006\u0003\u0002,\u0005]\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\t\u0005E\u0012qA\u0001\u0005G>\u0014X-\u0003\u0003\u00026\u0005=\"\u0001\u0003*fgB|gn]3\t\u0011\u0005e\u0012Q\u0005a\u0001\u0003w\t!\u0002^3na2\fG/Z%e!\u0011\ti$a\u0013\u000f\t\u0005}\u0012q\t\t\u0004\u0003\u0003\u0002RBAA\"\u0015\r\t)\u0005D\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%\u0003#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\nyE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0013\u0002\u0002\u0006BA\u001c\u0003'\u0002B!!\u0016\u0002d5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&\u0001\u0002jI*!\u0011QLA0\u0003!\u0001H.^7cS:<'bAA1\u0011\u0005AA-\u001a9m_fLG/\u0003\u0003\u0002f\u0005]#aB%e!\u0006\u0014\u0018-\u001c\u0015\t\u0003o\tI'a\u0006\u0002pA!\u0011QAA6\u0013\u0011\ti'a\u0002\u0003\u0013A\u000bG\u000f\u001b)be\u0006l\u0017EAA\u001dQ!\t)#a\u0001\u0002\u0018\u0005M\u0014EAA;\u0003\u001dz3\u0010^3na2\fG/Z%eu9R#+\u001a7fCN,7LX\u0018.;*jxF]3wSNLwN\\:)\t\u0005\u0015\u0012q\u0004\u0005\b\u0003w\u0002A\u0011AA?\u0003I9W\r\u001e*fm&\u001c\u0018n\u001c8D_:$XM\u001c;\u0015\r\u0005-\u0012qPAC\u0011!\tI$!\u001fA\u0002\u0005m\u0002\u0006BA@\u0003'B\u0003\"a \u0002j\u0005]\u0011q\u000e\u0005\t\u0003\u000f\u000bI\b1\u0001\u0002\n\u0006Q!/\u001a<jg&|g.\u00133\u0011\u0007=\tY)C\u0002\u0002\u000eB\u00111!\u00138uQ!\t))!\u001b\u0002\u0018\u0005E\u0015EAADQ!\tI(a\u0001\u0002\u0018\u0005U\u0015EAAL\u0003qz3\u0010^3na2\fG/Z%eu9R#+\u001a7fCN,7LX\u0018.;*jxF]3wSNLwN\\:0wJ,g/[:j_:LE-`\u0018d_:$XM\u001c;)\t\u0005e\u0014q\u0004\u0005\b\u0003;\u0003A\u0011AAP\u00035\u0019'/Z1uKZ+'o]5p]R1\u00111FAQ\u0003OC\u0001\"!\u000f\u0002\u001c\u0002\u0007\u00111\b\u0015\u0005\u0003C\u000b\u0019\u0006\u000b\u0005\u0002\"\u0006%\u0014qCA8\u0011!\tI+a'A\u0002\u0005-\u0016a\u0003<feNLwN\u001c,jK^\u0004B!!,\u000246\u0011\u0011q\u0016\u0006\u0004\u0003c\u0013\u0011!\u0002<jK^\u001c\u0018\u0002BA[\u0003_\u00131BV3sg&|gNV5fo\"B\u00111TA\u0002\u0003/\tI,\t\u0002\u0002<\u00061sf\u001f;f[Bd\u0017\r^3JIjr#FU3mK\u0006\u001cXm\u001700[uSSp\f<feNLwN\\:)\t\u0005m\u0015q\u0018\t\u0005\u0003\u000b\t\t-\u0003\u0003\u0002D\u0006\u001d!\u0001\u0002)P'RCq!a2\u0001\t\u0003\tI-A\bsKN$xN]3SKZL7/[8o)\u0019\tY#a3\u0002R\"A\u0011\u0011HAc\u0001\u0004\tY\u0004\u000b\u0003\u0002L\u0006M\u0003\u0006CAf\u0003S\n9\"a\u001c\t\u0011\u0005\u001d\u0015Q\u0019a\u0001\u0003\u0013C\u0003\"!5\u0002j\u0005]\u0011\u0011\u0013\u0015\t\u0003\u000b\f\u0019!a\u0006\u0002X\u0006\u0012\u0011\u0011\\\u0001=_m$X-\u001c9mCR,\u0017\n\u001a\u001e/UI+G.Z1tKnsv&L/+{>\u0012XM^5tS>t7oL>sKZL7/[8o\u0013\u0012lxF]3ti>\u0014X\r\u000b\u0003\u0002F\u0006u\u0007\u0003BA\u0003\u0003?LA!!9\u0002\b\t\u0019\u0001+\u0016+\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\u0006qA-\u001a7fi\u0016\u0014VM^5tS>tGCBA\u0016\u0003S\fy\u000f\u0003\u0005\u0002:\u0005\r\b\u0019AA\u001eQ\u0011\tI/a\u0015)\u0011\u0005%\u0018\u0011NA\f\u0003_B\u0001\"a\"\u0002d\u0002\u0007\u0011\u0011\u0012\u0015\t\u0003_\fI'a\u0006\u0002\u0012\"B\u00111]A\u0002\u0003/\t)0\t\u0002\u0002x\u0006!tf\u001f;f[Bd\u0017\r^3JIjr#FU3mK\u0006\u001cXm\u001700[uSSp\f:fm&\u001c\u0018n\u001c8t_m\u0014XM^5tS>t\u0017\nZ?)\t\u0005\r\u00181 \t\u0005\u0003\u000b\ti0\u0003\u0003\u0002\u0000\u0006\u001d!A\u0002#F\u0019\u0016#V\tC\u0004\u0003\u0004\u0001!\tA!\u0002\u0002\u001f\u0011,G.\u001a;f%\u00164\u0018n]5p]N$b!a\u000b\u0003\b\t5\u0001\u0002CA\u001d\u0005\u0003\u0001\r!a\u000f)\t\t\u001d\u00111\u000b\u0015\t\u0005\u000f\tI'a\u0006\u0002p!A!q\u0002B\u0001\u0001\u0004\u0011\t\"A\u0006sKZL7/[8o\u0013\u0012\u001c\bC\u0002B\n\u0005;\tI)\u0004\u0002\u0003\u0016)!!q\u0003B\r\u0003\u0011)H/\u001b7\u000b\u0005\tm\u0011\u0001\u00026bm\u0006LAAa\b\u0003\u0016\t!A*[:uQ!\u0011\t!a\u0001\u0002\u0018\u0005M\u0004\u0006\u0002B\u0001\u0003wDqAa\n\u0001\t\u0003\u0011I#A\u0004d_6\u0004\u0018M]3\u0015\u0011\t-\"\u0011\u0007B\u001c\u0005\u001b\u0002B!!,\u0003.%!!qFAX\u0005i!V-\u001c9mCR,7i\u001c8uK:$\u0018I\u001c3Qe\u00164\u0018n\\;t\u0011!\tID!\nA\u0002\u0005m\u0002\u0006\u0002B\u0019\u0003'B\u0003B!\r\u0002j\u0005]\u0011q\u000e\u0005\t\u0003\u000f\u0013)\u00031\u0001\u0002\n\"B!q\u0007B\u001e\u0003/\t\t\n\u0005\u0003\u0002\u0006\tu\u0012\u0002\u0002B \u0003\u000f\u0011!\"U;fef\u0004\u0016M]1nQ!\u00119Da\u0011\u0002\u0018\t%\u0003\u0003BA\u0003\u0005\u000bJAAa\u0012\u0002\b\taA)\u001a4bk2$h+\u00197vK\u0006\u0012!1J\u0001\u0002a!A!q\nB\u0013\u0001\u0004\tI)\u0001\u0007u_J+g/[:j_:LE\r\u000b\u0005\u0003N\tm\u0012q\u0003B*C\t\u0011y\u0005\u000b\u0005\u0003N\t\r\u0013q\u0003B%Q!\u0011)#a\u0001\u0002\u0018\te\u0013E\u0001B.\u0003\u0015z3\u0010^3na2\fG/Z%eu9R#+\u001a7fCN,7LX\u0018.;*jxfY8na\u0006\u0014X\r\u000b\u0003\u0003&\u0005}\u0001b\u0002B1\u0001\u0011\u0005!1M\u0001\u0015O\u0016$(+Z:pYV$\u0018n\u001c8D_:$X\r\u001f;\u0015\t\t\u0015$\u0011\u000f\t\u0005\u0005O\u0012i'\u0004\u0002\u0003j)!!1NA.\u00035\u0019XM]5bY&T\u0018\r^5p]&!!q\u000eB5\u0005E\u0011Vm]8mkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\t\u0003s\u0011y\u00061\u0001\u0002<!9!Q\u000f\u0001\u0005\n\t]\u0014\u0001E4fiR+W\u000e\u001d7bi\u0016\f5\u000fR:m)\u0011\tYD!\u001f\t\u0011\tm$1\u000fa\u0001\u0005{\n\u0001\u0002^3na2\fG/\u001a\t\u0005\u0005\u007f\u0012\u0019)\u0004\u0002\u0003\u0002*\u00111PB\u0005\u0005\u0005\u000b\u0013\tIA\u0004SK2,\u0017m]3)\u0007\u0001\u0011I\t\u0005\u0003\u0003\f\nEUB\u0001BG\u0015\r\u0011yi\\\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002BJ\u0005\u001b\u0013!bQ8oiJ|G\u000e\\3sQ\u001d\u0001!qSA\f\u0005;\u0003B!!\u0002\u0003\u001a&!!1TA\u0004\u0005!\u0019uN\\:v[\u0016\u001cHF\u0001BPC\t\u0011\t+\u0001\tbaBd\u0017nY1uS>twF[:p]\":\u0001A!*\u0002\u0018\t-\u0006\u0003BA\u0003\u0005OKAA!+\u0002\b\tA\u0001K]8ek\u000e,7\u000f\f\u0002\u0003 \":\u0001!a\u0001\u0002\u0018\t=\u0016E\u0001BY\u0003-yc/\u001a:tS>t\u0017N\\4")
public class TemplateVersioningResource
implements Logging {
    private final DslExporter dslExporter;
    private final TemplateRevisionRepository templateRevisionRepository;
    private final TemplateStorageService templateStorageService;
    private final ReleaseActorService releaseActorService;
    private final PermissionChecker permissionChecker;
    private final ReleaseService releaseService;
    private final ConfigurationRepository configurationRepository;
    private final ScmTemplateStorageService templateStorageListener;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TemplateVersioningResource templateVersioningResource = this;
        synchronized (templateVersioningResource) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/settings")
    public TemplateVersioningSettings getTemplateVersionoingSettings() {
        return (TemplateVersioningSettings)this.configurationRepository.read(TemplateVersioningSettings$.MODULE$.TEMPLATE_VERSIONING_ID());
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/revisions")
    public Response getRevisions(@PathParam(value="templateId") @IdParam String templateId) {
        this.permissionChecker.checkView(templateId);
        List<TemplateRevision> templateRevisions = this.templateRevisionRepository.find(templateId, new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0)));
        GenericEntity<List<TemplateRevision>> entity = new GenericEntity<List<TemplateRevision>>(null, templateRevisions){};
        return Response.ok((Object)entity).build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}/content")
    public Response getRevisionContent(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.checkView(templateId);
        Release template = this.templateStorageService.load(revisionId, this.getResolutionContext(templateId));
        return Response.ok((Object)this.getTemplateAsDsl(template), (String)"text/plain").build();
    }

    @POST
    @Path(value="/{templateId:.*Release[^/-]*}/versions")
    public Response createVersion(@PathParam(value="templateId") @IdParam String templateId, VersionView versionView) {
        Checks.checkArgument((boolean)this.releaseService.isTemplate(templateId), (String)"Snapshots can only be created for templates", (Object[])new Object[0]);
        this.permissionChecker.checkEdit(templateId);
        String user = Permissions.getAuthenticatedUserName();
        Try result = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.templateStorageListener.createNewVersion(templateId, versionView.name(), versionView.description(), user)).map((Function1 & Serializable & scala.Serializable)tagName -> {
            Try r = (Try)$this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new TemplateVersionExtensionActorMessages.NewTemplateVersion((String)tagName, versionView.description(), user));
            return new Tuple2(tagName, (Object)r);
        }).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Try try_;
            Try r;
            Tuple2 tuple2 = x$1;
            if (tuple2 == null || (r = (Try)tuple2._2()) == null) {
                throw new MatchError((Object)tuple2);
            }
            Try try_2 = try_ = r;
            return try_2;
        });
        return Response.ok((Object)result.fold((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CreateVersionResponse createVersionResponse;
            Throwable throwable = x0$1;
            if (throwable instanceof TemplateVersioningException) {
                TemplateVersioningException templateVersioningException = (TemplateVersioningException)((Object)((Object)throwable));
                String msg = templateVersioningException.msg();
                int statusCode = templateVersioningException.statusCode();
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> "Unable to create a new version of a template.", (Function0 & Serializable & scala.Serializable)() -> templateVersioningException);
                createVersionResponse = new CreateVersionResponse(false, msg, statusCode);
            } else if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> "Unable to create a new version of a template.", (Function0 & Serializable & scala.Serializable)() -> throwable2);
                createVersionResponse = new CreateVersionResponse(false, throwable2.getMessage(), 500);
            } else {
                throw new MatchError((Object)throwable);
            }
            return createVersionResponse;
        }, (Function1 & Serializable & scala.Serializable)id -> new CreateVersionResponse(true, id.toString(), CreateVersionResponse$.MODULE$.$lessinit$greater$default$3()))).build();
    }

    @PUT
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}/restore")
    public Response restoreRevision(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        Release template = this.releaseService.findById(templateId);
        this.permissionChecker.check(XLReleasePermissions.EDIT_TEMPLATE, template);
        this.permissionChecker.check(XLReleasePermissions.EDIT_TRIGGERS, template);
        this.permissionChecker.check(XLReleasePermissions.CREATE_RELEASE_FROM_TEMPLATE, template);
        this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new TemplateVersionExtensionActorMessages.RestoreRevision(revisionId));
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}")
    public Response deleteRevision(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.checkEdit(templateId);
        this.templateStorageService.deleteRevision(templateId, revisionId);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{templateId:.*Release[^/-]*}/revisions")
    public Response deleteRevisions(@PathParam(value="templateId") @IdParam String templateId, List<Object> revisionIds) {
        this.permissionChecker.checkEdit(templateId);
        this.templateStorageService.deleteRevisions(templateId, (Seq<Object>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(revisionIds).asScala()));
        return Response.ok().build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/compare")
    public TemplateContentAndPrevious compare(@PathParam(value="templateId") @IdParam String templateId, @DefaultValue(value="0") @QueryParam(value="revisionId") int revisionId, @DefaultValue(value="0") @QueryParam(value="toRevisionId") int toRevisionId) {
        this.permissionChecker.checkView(templateId);
        Release revision = revisionId == 0 ? this.releaseService.findById(templateId) : this.templateStorageService.load(revisionId, this.getResolutionContext(templateId));
        Release toRevision = toRevisionId == 0 ? this.releaseService.findById(templateId) : this.templateStorageService.load(toRevisionId, this.getResolutionContext(templateId));
        return new TemplateContentAndPrevious(this.getTemplateAsDsl(revision), this.getTemplateAsDsl(toRevision));
    }

    public ResolutionContext getResolutionContext(String templateId) {
        return Ids.isInFolder((String)templateId) ? new ResolutionContext((Option)new Some((Object)Ids.getParentId((String)templateId))) : new ResolutionContext((Option)None$.MODULE$);
    }

    private String getTemplateAsDsl(Release template) {
        return this.dslExporter.exportTemplate(template, this.dslExporter.exportTemplate$default$2());
    }

    @Autowired
    public TemplateVersioningResource(DslExporter dslExporter, TemplateRevisionRepository templateRevisionRepository, TemplateStorageService templateStorageService, ReleaseActorService releaseActorService, PermissionChecker permissionChecker, ReleaseService releaseService, ConfigurationRepository configurationRepository, ScmTemplateStorageService templateStorageListener) {
        this.dslExporter = dslExporter;
        this.templateRevisionRepository = templateRevisionRepository;
        this.templateStorageService = templateStorageService;
        this.releaseActorService = releaseActorService;
        this.permissionChecker = permissionChecker;
        this.releaseService = releaseService;
        this.configurationRepository = configurationRepository;
        this.templateStorageListener = templateStorageListener;
        Logging.$init$((Logging)this);
    }
}

