/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.templates;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext$;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseRestoredEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.DependencyTargetResolver;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.upgrade.Components;
import com.xebialabs.xlrelease.versioning.templates.ReleaseVersioningSerialization;
import com.xebialabs.xlrelease.versioning.templates.TemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.domain.events.RevisionDeletedEvent;
import com.xebialabs.xlrelease.versioning.templates.domain.events.VersionCreatedEvent;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionDataRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevision;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevisionData;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevisionType$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@Service
@Primary
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001\u0002\r\u001a\u0001\u0011B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u0011]\u0003!\u0011!Q\u0001\naC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tI\u0002\u0011\t\u0011)A\u0005K\"A1\u000e\u0001B\u0001B\u0003%A\u000eC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R!9\u0011\u0011\u000f\u0001\u0005\n\u0005M\u0004\"CAI\u0001E\u0005I\u0011BAJ\u0011\u001d\t9\u000b\u0001C!\u0003SCq!!-\u0001\t\u0003\n\u0019\fC\u0004\u0002P\u0002!\t%!5\t\u000f\u0005]\u0007\u0001\"\u0011\u0002Z\"9\u00111\u001f\u0001\u0005\n\u0005U\bbBA\u0000\u0001\u0011%!\u0011\u0001\u0005\b\u0005\u000b\u0001A\u0011\u0002B\u0004\u0011\u001d\u0011\t\u0002\u0001C\u0005\u0005'\u0011\u0001\u0004\u00122UK6\u0004H.\u0019;f'R|'/Y4f'\u0016\u0014h/[2f\u0015\tQ2$A\u0005uK6\u0004H.\u0019;fg*\u0011A$H\u0001\u000bm\u0016\u00148/[8oS:<'B\u0001\u0010 \u0003%AHN]3mK\u0006\u001cXM\u0003\u0002!C\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002E\u0005\u00191m\\7\u0004\u0001M!\u0001!J\u00160!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019\te.\u001f*fMB\u0011A&L\u0007\u00023%\u0011a&\u0007\u0002\u0017)\u0016l\u0007\u000f\\1uKN#xN]1hKN+'O^5dKB\u0011\u0001'N\u0007\u0002c)\u0011!gM\u0001\u0006g24GG\u001b\u0006\u0002i\u0005AqM]5{u2,G-\u0003\u00027c\t9Aj\\4hS:<\u0017A\u0007;f[Bd\u0017\r^3SKZL7/[8o%\u0016\u0004xn]5u_JL\bCA\u001d=\u001b\u0005Q$BA\u001e\u001a\u0003)\u0011X\r]8tSR|'/_\u0005\u0003{i\u0012!\u0004V3na2\fG/\u001a*fm&\u001c\u0018n\u001c8SKB|7/\u001b;pef\fa\u0004^3na2\fG/\u001a*fm&\u001c\u0018n\u001c8ECR\f'+\u001a9pg&$xN]=\u0011\u0005e\u0002\u0015BA!;\u0005y!V-\u001c9mCR,'+\u001a<jg&|g\u000eR1uCJ+\u0007o\\:ji>\u0014\u00180\u0001\u0010sK2,\u0017m]3WKJ\u001c\u0018n\u001c8j]\u001e\u001cVM]5bY&T\u0018\r^5p]B\u0011A\u0006R\u0005\u0003\u000bf\u0011aDU3mK\u0006\u001cXMV3sg&|g.\u001b8h'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u0002\u001dI,G.Z1tKN+'O^5dKB\u0011\u0001jS\u0007\u0002\u0013*\u0011!*H\u0001\bg\u0016\u0014h/[2f\u0013\ta\u0015J\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002P#6\t\u0001K\u0003\u0002<;%\u0011!\u000b\u0015\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018a\u0003;bg.\u001cVM\u001d<jG\u0016\u0004\"\u0001S+\n\u0005YK%a\u0003+bg.\u001cVM\u001d<jG\u0016\f1\u0002^3b[N+'O^5dKB\u0011\u0001*W\u0005\u00035&\u00131\u0002V3b[N+'O^5dK\u0006A\"/\u001a9pg&$xN]=WKJ\u001c\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017aB;qOJ\fG-\u001a\u0006\u0003C~\t!\u0002\u001f7qY\u0006$hm\u001c:n\u0013\t\u0019gL\u0001\rSKB|7/\u001b;pef4VM]:j_:\u001cVM\u001d<jG\u0016\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003M&l\u0011a\u001a\u0006\u0003Qv\ta!\u001a<f]R\u001c\u0018B\u00016h\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\u0019I\u0016\u0004XM\u001c3f]\u000eLH+\u0019:hKR\u0014Vm]8mm\u0016\u0014\bCA(n\u0013\tq\u0007K\u0001\rEKB,g\u000eZ3oGf$\u0016M]4fiJ+7o\u001c7wKJ\fa\u0001P5oSRtDcC9sgR,ho\u001e=zun\u0004\"\u0001\f\u0001\t\u000b]Z\u0001\u0019\u0001\u001d\t\u000byZ\u0001\u0019A \t\u000b\t[\u0001\u0019A\"\t\u000b\u0019[\u0001\u0019A$\t\u000b5[\u0001\u0019\u0001(\t\u000bM[\u0001\u0019\u0001+\t\u000b][\u0001\u0019\u0001-\t\u000bm[\u0001\u0019\u0001/\t\u000b\u0011\\\u0001\u0019A3\t\u000b-\\\u0001\u0019\u00017)\u0005-i\bc\u0001@\u0002\u00145\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011AC1o]>$\u0018\r^5p]*!\u0011QAA\u0004\u0003\u001d1\u0017m\u0019;pefTA!!\u0003\u0002\f\u0005)!-Z1og*!\u0011QBA\b\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA\t\u0003\ry'oZ\u0005\u0004\u0003+y(!C!vi><\u0018N]3e\u00031\u0019\u0018M^3SKZL7/[8o)!\tY\"!\t\u00022\u0005-\u0003c\u0001\u0014\u0002\u001e%\u0019\u0011qD\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003Ga\u0001\u0019AA\u0013\u0003!!X-\u001c9mCR,\u0007\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-R$\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003_\tICA\u0004SK2,\u0017m]3\t\u000f\u0005MB\u00021\u0001\u00026\u0005!Qo]3s!\u0011\t9$!\u0012\u000f\t\u0005e\u0012\u0011\t\t\u0004\u0003w9SBAA\u001f\u0015\r\tydI\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\rs%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\nIE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0007:\u0003bBA'\u0019\u0001\u0007\u0011QG\u0001\b[\u0016\u001c8/Y4f\u0003-\u0019\u0018M^3WKJ\u001c\u0018n\u001c8\u0015\u0015\u0005M\u0013QMA5\u0003W\ny\u0007\u0005\u0004\u0002V\u0005m\u0013qL\u0007\u0003\u0003/R1!!\u0017(\u0003\u0011)H/\u001b7\n\t\u0005u\u0013q\u000b\u0002\u0004)JL\bc\u0001\u0014\u0002b%\u0019\u00111M\u0014\u0003\u0007%sG\u000fC\u0004\u0002h5\u0001\r!!\u000e\u0002\u0015Q,W\u000e\u001d7bi\u0016LE\rC\u0004\u000245\u0001\r!!\u000e\t\u000f\u00055T\u00021\u0001\u00026\u0005Ya/\u001a:tS>tg*Y7f\u0011\u001d\ti%\u0004a\u0001\u0003k\tab\u0019:fCR,'+\u001a<jg&|g\u000e\u0006\u0006\u0002v\u0005\u0015\u0015qQAE\u0003\u001b\u0003B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(\u0001\u0003eCR\f'bAA@u\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\u0011\t\u0019)!\u001f\u0003!Q+W\u000e\u001d7bi\u0016\u0014VM^5tS>t\u0007bBA\u0012\u001d\u0001\u0007\u0011Q\u0005\u0005\b\u0003gq\u0001\u0019AA\u001b\u0011\u001d\tYI\u0004a\u0001\u0003k\t1\u0002Z3tGJL\u0007\u000f^5p]\"I\u0011q\u0012\b\u0011\u0002\u0003\u0007\u0011QG\u0001\bm\u0016\u00148/[8o\u0003a\u0019'/Z1uKJ+g/[:j_:$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003+SC!!\u000e\u0002\u0018.\u0012\u0011\u0011\u0014\t\u0005\u00037\u000b\u0019+\u0004\u0002\u0002\u001e*!\u0011qTAQ\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0002\u001dJA!!*\u0002\u001e\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u000fI,7\u000f^8sKR1\u0011QEAV\u0003[Cq!a\u001a\u0011\u0001\u0004\t)\u0004C\u0004\u00020B\u0001\r!a\u0018\u0002\u0015I,g/[:j_:LE-\u0001\u0003m_\u0006$GCBA\u0013\u0003k\u000b9\fC\u0004\u00020F\u0001\r!a\u0018\t\u000f\u0005e\u0016\u00031\u0001\u0002<\u000691m\u001c8uKb$\b\u0003BA_\u0003\u0017l!!a0\u000b\t\u0005\u0005\u00171Y\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\t\u0005\u0015\u0017qY\u0001\ta2,XNY5oO*\u0019\u0011\u0011Z\u0010\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!!4\u0002@\n\t\"+Z:pYV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u001d\u0011,G.\u001a;f%\u00164\u0018n]5p]R1\u00111DAj\u0003+Dq!a\u001a\u0013\u0001\u0004\t)\u0004C\u0004\u00020J\u0001\r!a\u0018\u0002\u001f\u0011,G.\u001a;f%\u00164\u0018n]5p]N$b!a\u0007\u0002\\\u0006u\u0007bBA4'\u0001\u0007\u0011Q\u0007\u0005\b\u0003?\u001c\u0002\u0019AAq\u0003-\u0011XM^5tS>t\u0017\nZ:\u0011\r\u0005\r\u0018Q^A0\u001d\u0011\t)/!;\u000f\t\u0005m\u0012q]\u0005\u0002Q%\u0019\u00111^\u0014\u0002\u000fA\f7m[1hK&!\u0011q^Ay\u0005\r\u0019V-\u001d\u0006\u0004\u0003W<\u0013a\u00069s_\u000e,7o\u001d*fgR|'/\u001a3UK6\u0004H.\u0019;f)\u0019\tY\"a>\u0002|\"9\u0011\u0011 \u000bA\u0002\u0005\u0015\u0012\u0001\u0005:fgR|'/\u001a3UK6\u0004H.\u0019;f\u0011\u001d\ti\u0010\u0006a\u0001\u0003K\tqbY;se\u0016tG\u000fV3na2\fG/Z\u0001\u0014aJ|7-Z:t\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u000b\u0005\u0003K\u0011\u0019\u0001C\u0004\u0002zV\u0001\r!!\n\u0002#1|\u0017\r\u001a'bi\u0016\u001cHOV3sg&|g\u000e\u0006\u0003\u0003\n\t=\u0001#\u0002\u0014\u0003\f\u0005\u0015\u0012b\u0001B\u0007O\t1q\n\u001d;j_:Dq!a\u001a\u0017\u0001\u0004\t)$\u0001\u0006yYJ4VM]:j_:,\"!!\u000e)\u0007\u0001\u00119\u0002\u0005\u0003\u0003\u001a\t\u001dRB\u0001B\u000e\u0015\u0011\u0011iBa\b\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0005\u0005C\u0011\u0019#A\u0002tc2T1A!\n\u001e\u0003\t!'-\u0003\u0003\u0003*\tm!aD%t)J\fgn]1di&|g.\u00197)\u0007\u0001\u0011i\u0003\u0005\u0003\u00030\tURB\u0001B\u0019\u0015\u0011\t\tAa\r\u000b\t\u0005e\u00161B\u0005\u0005\u0005o\u0011\tDA\u0004Qe&l\u0017M]=)\u0007\u0001\u0011Y\u0004\u0005\u0003\u0003>\t\rSB\u0001B \u0015\u0011\u0011\t%a\u0003\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003F\t}\"aB*feZL7-\u001a")
public class DbTemplateStorageService
implements TemplateStorageService,
Logging {
    private final TemplateRevisionRepository templateRevisionRepository;
    private final TemplateRevisionDataRepository templateRevisionDataRepository;
    private final ReleaseVersioningSerialization releaseVersioningSerialization;
    private final ReleaseService releaseService;
    private final ReleaseRepository releaseRepository;
    private final RepositoryVersionService repositoryVersionService;
    private final XLReleaseEventBus eventBus;
    private final DependencyTargetResolver dependencyTargetResolver;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DbTemplateStorageService dbTemplateStorageService = this;
        synchronized (dbTemplateStorageService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public void saveRevision(Release template, String user, String message) {
        this.createRevision(template, user, message, this.createRevision$default$4());
    }

    @Override
    public Try<Object> saveVersion(String templateId, String user, String versionName, String message) {
        Release template = this.releaseService.findById(templateId);
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            TemplateRevision version = this.createRevision(template, user, message, versionName);
            $this.templateRevisionRepository.deleteRevisionsForVersion(version);
            $this.eventBus.publish((XLReleaseEvent)new VersionCreatedEvent(templateId, versionName));
            return version.id();
        }).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DbTemplateStorageService $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.logger().error((Function0 & Serializable & scala.Serializable)() -> "Unable to create new template version", (Function0 & Serializable & scala.Serializable)() -> exception);
                    object = new Failure((Throwable)exception);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(java.lang.Exception )}, serializedLambda);
            }
        });
    }

    private TemplateRevision createRevision(Release template, String user, String description, String version) {
        TemplateRevision templateRevision = new TemplateRevision();
        templateRevision.ciUid_$eq(Predef$.MODULE$.Integer2int(template.getCiUid()));
        templateRevision.revisionType_$eq(version != null ? TemplateRevisionType$.MODULE$.VERSION() : TemplateRevisionType$.MODULE$.REVISION());
        templateRevision.version_$eq(version);
        templateRevision.description_$eq(description);
        templateRevision.username_$eq(user);
        templateRevision.revisionTime_$eq(new Date());
        TemplateRevision savedTr = this.templateRevisionRepository.create(templateRevision);
        TemplateRevisionData trd = new TemplateRevisionData(savedTr.id(), this.xlrVersion(), this.releaseVersioningSerialization.toBytes(template));
        this.templateRevisionDataRepository.create(trd);
        return savedTr;
    }

    private String createRevision$default$4() {
        return null;
    }

    @Override
    public Release restore(String templateId, int revisionId) {
        Release currentTemplate = this.releaseService.findById(templateId);
        ResolutionContext context = Ids.isInFolder((String)templateId) ? ResolutionContext$.MODULE$.apply(Ids.getParentId((String)templateId)) : ResolutionContext$.MODULE$.GLOBAL();
        Release previousTemplate = this.load(revisionId, context);
        this.processRestoredTemplate(previousTemplate, currentTemplate);
        Release updatedTemplate = this.releaseRepository.replace(currentTemplate, previousTemplate);
        this.eventBus.publish((XLReleaseEvent)new ReleaseRestoredEvent(currentTemplate, updatedTemplate, revisionId));
        return this.releaseService.findById(templateId);
    }

    @Override
    public Release load(int revisionId, ResolutionContext context) {
        Release release;
        Option<TemplateRevisionData> option = this.templateRevisionDataRepository.findById(revisionId);
        if (option instanceof Some) {
            Some some = (Some)option;
            TemplateRevisionData trd = (TemplateRevisionData)some.value();
            Option<Release> option2 = this.releaseVersioningSerialization.fromBytes(trd.content(), trd.dataModelVersion(), context);
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new LogFriendlyNotFoundException(new StringBuilder(41).append("Error reading ").append(revisionId).append(", see logs for more details").toString(), new Object[0]);
                }
                throw new MatchError(option2);
            }
            Some some2 = (Some)option2;
            Release template = (Release)some2.value();
            release = this.processDependencies(template);
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new LogFriendlyNotFoundException(new StringBuilder(22).append("Revision id ").append(revisionId).append(" not found").toString(), new Object[0]);
            }
            throw new MatchError(option);
        }
        Release release2 = release;
        return release2;
    }

    @Override
    public void deleteRevision(String templateId, int revisionId) {
        this.templateRevisionRepository.deleteRevisions(templateId, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{revisionId}))));
        this.eventBus.publish((XLReleaseEvent)new RevisionDeletedEvent(templateId, revisionId));
    }

    @Override
    public void deleteRevisions(String templateId, Seq<Object> revisionIds) {
        this.templateRevisionRepository.deleteRevisions(templateId, revisionIds);
        revisionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> $this.eventBus.publish((XLReleaseEvent)new RevisionDeletedEvent(templateId, id)));
    }

    private void processRestoredTemplate(Release restoredTemplate, Release currentTemplate) {
        restoredTemplate.setCiUid(currentTemplate.getCiUid());
        CiHelper.rewriteWithNewId((ConfigurationItem)restoredTemplate, (String)currentTemplate.getId());
        restoredTemplate.setRunningTriggeredReleasesCount(currentTemplate.getRunningTriggeredReleasesCount());
        this.processDependencies(restoredTemplate);
        restoredTemplate.get$ciAttributes().setScmTraceabilityDataId(null);
    }

    private Release processDependencies(Release restoredTemplate) {
        restoredTemplate.getAllGates().forEach(gateTask -> {
            List validDependencies = gateTask.getDependencies().stream().filter(d -> d.hasResolvedTarget() || Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.dependencyTargetResolver.resolveTarget(d)).isSuccess()).collect(Collectors.toList());
            gateTask.setDependencies(validDependencies);
        });
        return restoredTemplate;
    }

    private Option<Release> loadLatestVersion(String templateId) {
        ResolutionContext context = Ids.isInFolder((String)templateId) ? ResolutionContext$.MODULE$.apply(Ids.getParentId((String)templateId)) : ResolutionContext$.MODULE$.GLOBAL();
        return this.templateRevisionRepository.latestVersion(templateId).map((Function1 & Serializable & scala.Serializable)template -> this.load(template.id(), context));
    }

    private String xlrVersion() {
        Version version = this.repositoryVersionService.readVersionOfComponent(Components.XL_RELEASE_COMPONENT);
        return version == null ? "0.0.0" : version.getVersion();
    }

    @Autowired
    public DbTemplateStorageService(TemplateRevisionRepository templateRevisionRepository, TemplateRevisionDataRepository templateRevisionDataRepository, ReleaseVersioningSerialization releaseVersioningSerialization, ReleaseService releaseService, ReleaseRepository releaseRepository, TaskService taskService, TeamService teamService, RepositoryVersionService repositoryVersionService, XLReleaseEventBus eventBus, DependencyTargetResolver dependencyTargetResolver) {
        this.templateRevisionRepository = templateRevisionRepository;
        this.templateRevisionDataRepository = templateRevisionDataRepository;
        this.releaseVersioningSerialization = releaseVersioningSerialization;
        this.releaseService = releaseService;
        this.releaseRepository = releaseRepository;
        this.repositoryVersionService = repositoryVersionService;
        this.eventBus = eventBus;
        this.dependencyTargetResolver = dependencyTargetResolver;
        Logging.$init$((Logging)this);
    }
}

