/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.scm.connector.gitlab;

import com.google.common.net.UrlEscapers;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException;
import com.xebialabs.xlrelease.versioning.scm.connector.BasicScmConnector;
import com.xebialabs.xlrelease.versioning.scm.connector.Blobs;
import com.xebialabs.xlrelease.versioning.scm.connector.HttpClientRequest$;
import com.xebialabs.xlrelease.versioning.scm.connector.ScmHttpClientWrapper;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabCommit;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabCommitAction;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabCommitResponse;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabProjectResponse;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabScmConnectorConfig;
import com.xebialabs.xlrelease.versioning.scm.connector.gitlab.GitLabTree;
import java.io.Serializable;
import java.util.Base64;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001\u0002\b\u0010\u0001yA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006Q\u0001!\t!\u000b\u0005\u0006Y\u0001!\t&\f\u0005\u0006u\u0001!\tf\u000f\u0005\u0006)\u0002!\t&\u0016\u0005\u00069\u0002!\t!\u0018\u0005\u0006=\u0002!Ia\u0018\u0005\u0006S\u0002!IA\u001b\u0005\b\u0003\u000b\u0001A\u0011BA\u0004\u0011\u001d\t\u0019\u0002\u0001C\u0005\u0003+Aq!!\f\u0001\t\u0013\ty\u0003C\u0004\u00022\u0001!I!a\r\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<\t\u0011r)\u001b;MC\n\u001c6-\\\"p]:,7\r^8s\u0015\t\u0001\u0012#\u0001\u0004hSRd\u0017M\u0019\u0006\u0003%M\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005Q)\u0012aA:d[*\u0011acF\u0001\u000bm\u0016\u00148/[8oS:<'B\u0001\r\u001a\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001b7\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00029\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\b\t\u0003A\u0005j\u0011!E\u0005\u0003EE\u0011\u0011CQ1tS\u000e\u001c6-\\\"p]:,7\r^8s\u0003\u0019\u0019wN\u001c4jOB\u0011QEJ\u0007\u0002\u001f%\u0011qe\u0004\u0002\u0019\u000f&$H*\u00192TG6\u001cuN\u001c8fGR|'oQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u0002+WA\u0011Q\u0005\u0001\u0005\u0006G\t\u0001\r\u0001J\u0001\u000fi\u0016\u001cHOU3q_NLGo\u001c:z+\u0005q\u0003cA\u00185m5\t\u0001G\u0003\u00022e\u0005!Q\u000f^5m\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b1\u0005\r!&/\u001f\t\u0003oaj\u0011AM\u0005\u0003sI\u0012A!\u00168ji\u0006a1m\\7nSR\fe\u000e\u001a+bOR!A\bS'S!\ryC'\u0010\t\u0003}\u0015s!aP\"\u0011\u0005\u0001\u0013T\"A!\u000b\u0005\tk\u0012A\u0002\u001fs_>$h(\u0003\u0002Ee\u00051\u0001K]3eK\u001aL!AR$\u0003\rM#(/\u001b8h\u0015\t!%\u0007C\u0003J\t\u0001\u0007!*A\u0003cY>\u00147\u000f\u0005\u0002!\u0017&\u0011A*\u0005\u0002\u0006\u00052|'m\u001d\u0005\u0006\u001d\u0012\u0001\raT\u0001\u000bG>lW.\u001b;J]\u001a|\u0007C\u0001\u0011Q\u0013\t\t\u0016CA\nWC2LG-\u0019;fI\u000e{W.\\5u\u0013:4w\u000eC\u0003T\t\u0001\u0007Q(\u0001\u0003vg\u0016\u0014\u0018!\u0004;bO:{G\u000f\u0015:fg\u0016tG\u000f\u0006\u0002W5B\u0019q\u0006N,\u0011\u0005]B\u0016BA-3\u0005\u001d\u0011un\u001c7fC:DQaW\u0003A\u0002u\n1\u0001^1h\u00031\u0019'/Z1uK\n\u0013\u0018M\\2i)\u0005q\u0013\u0001D2sK\u0006$XmQ8n[&$HC\u00011e!\ryC'\u0019\t\u0003K\tL!aY\b\u0003)\u001dKG\u000fT1c\u0007>lW.\u001b;SKN\u0004xN\\:f\u0011\u0015)w\u00011\u0001g\u0003-\u0011X-];fgR\u0014u\u000eZ=\u0011\u0005\u0015:\u0017B\u00015\u0010\u000519\u0015\u000e\u001e'bE\u000e{W.\\5u\u0003%\u0019'/Z1uKR\u000bw\r\u0006\u0003l}\u0006\u0005\u0001cA\u00185YB\u0019Q\u000e\u001e<\u000e\u00039T!a\u001c9\u0002\t!$H\u000f\u001d\u0006\u0003cJ\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002g\u0006\u0019qN]4\n\u0005Ut'A\u0004*fgB|gn]3F]RLG/\u001f\t\u0003orl\u0011\u0001\u001f\u0006\u0003sj\fA\u0001\\1oO*\t10\u0001\u0003kCZ\f\u0017BA?y\u0005\u00111v.\u001b3\t\u000b}D\u0001\u0019A\u001f\u0002\u000fQ\fwMT1nK\"1\u00111\u0001\u0005A\u0002u\n1a\u001d5b\u0003Y\u0019'/Z1uK\u0012\u001bHNU3rk\u0016\u001cH/Q2uS>tG\u0003BA\u0005\u0003#\u0001Ba\f\u001b\u0002\fA\u0019Q%!\u0004\n\u0007\u0005=qB\u0001\nHSRd\u0015MY\"p[6LG/Q2uS>t\u0007\"B%\n\u0001\u0004Q\u0015AH2sK\u0006$X-\u0011;uC\u000eDW.\u001a8ugJ+\u0017/^3ti\u0006\u001bG/[8o)\u0011\t9\"a\u000b\u0011\t=\"\u0014\u0011\u0004\t\u0007\u00037\t)#a\u0003\u000f\t\u0005u\u0011\u0011\u0005\b\u0004\u0001\u0006}\u0011\"A\u001a\n\u0007\u0005\r\"'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0012\u0011\u0006\u0002\u0005\u0019&\u001cHOC\u0002\u0002$IBQ!\u0013\u0006A\u0002)\u000b\u0001B]3q_:\u000bW.Z\u000b\u0002{\u0005IQO\u001d7F]\u000e|G-\u001a\u000b\u0004{\u0005U\u0002BBA\u001c\u0019\u0001\u0007Q(A\u0003wC2,X-A\u0007hSRd\u0015M\u0019*fcV,7\u000f^\u000b\u0003\u0003{\u00012\u0001IA \u0013\r\t\t%\u0005\u0002\u0015'\u000el\u0007\n\u001e;q\u00072LWM\u001c;Xe\u0006\u0004\b/\u001a:")
public class GitLabScmConnector
extends BasicScmConnector {
    private final GitLabScmConnectorConfig config;

    @Override
    public Try<BoxedUnit> testRepository() {
        return this.gitLabRequest().get(new StringBuilder(10).append("/projects/").append(this.repoName()).toString()).doRequest(ClassTag$.MODULE$.apply(Void.class)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$1).tried()).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            GitLabScmConnector.$anonfun$testRepository$2(x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Try<String> commitAndTag(Blobs blobs, ValidatedCommitInfo commitInfo, String user) {
        return this.createBranch().flatMap((Function1 & Serializable & scala.Serializable)_ -> this.createDslRequestAction(blobs).flatMap((Function1 & Serializable & scala.Serializable)dslCommitAction -> this.createAttachmentsRequestAction(blobs).flatMap((Function1 & Serializable & scala.Serializable)attachmentCommitAction -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            GitLabCommitAction gitLabCommitAction = dslCommitAction;
            return new GitLabCommit($this.config.branch(), commitInfo.message(), JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)attachmentCommitAction.$colon$colon((Object)gitLabCommitAction)).asJavaCollection());
        }).flatMap((Function1 & Serializable & scala.Serializable)requestBody -> this.createCommit((GitLabCommit)requestBody).flatMap((Function1 & Serializable & scala.Serializable)gitCommitInfo -> this.createTag(commitInfo.tag().refName(), gitCommitInfo.id()).map((Function1 & Serializable & scala.Serializable)_ -> gitCommitInfo.id()))))));
    }

    @Override
    public Try<Object> tagNotPresent(String tag) {
        return this.gitLabRequest().get(new StringBuilder(27).append("/projects/").append(this.repoName()).append("/repository/tags/").append(tag).toString()).doRequest(ClassTag$.MODULE$.apply(Void.class)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)GitLabScmConnector.$anonfun$tagNotPresent$1(x$4)));
    }

    public Try<BoxedUnit> createBranch() {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ResponseEntity projectResponse = (ResponseEntity)this.gitLabRequest().get(new StringBuilder(10).append("/projects/").append(this.repoName()).toString()).doRequest(ClassTag$.MODULE$.apply(GitLabProjectResponse.class)).get();
            if (!HttpClientRequest$.MODULE$.ResponseEntityExtension(projectResponse).isSuccessful()) {
                throw new TemplateVersioningException("Unable to retrieve default branch", null, projectResponse.getStatusCodeValue());
            }
            boolean exist = HttpClientRequest$.MODULE$.ResponseEntityExtension((ResponseEntity)this.gitLabRequest().get(new StringBuilder(31).append("/projects/").append(this.repoName()).append("/repository/branches/").append($this.config.branch()).toString()).doRequest(ClassTag$.MODULE$.apply(Void.class)).get()).isSuccessful();
            if (!exist) {
                ScmHttpClientWrapper qual$1 = this.gitLabRequest().addQueryParam("ref", ((GitLabProjectResponse)projectResponse.getBody()).default_branch()).addQueryParam("branch", $this.config.branch());
                String x$1 = new StringBuilder(30).append("/projects/").append(this.repoName()).append("/repository/branches").toString();
                Null$ x$2 = qual$1.post$default$2();
                ResponseEntity response = (ResponseEntity)qual$1.post(x$1, null).doRequest(ClassTag$.MODULE$.apply(Void.class)).get();
                if (!HttpClientRequest$.MODULE$.ResponseEntityExtension(response).isSuccessful()) {
                    throw new TemplateVersioningException("Unable to create branch", null, response.getStatusCodeValue());
                }
            }
        });
    }

    private Try<GitLabCommitResponse> createCommit(GitLabCommit requestBody) {
        return this.gitLabRequest().post(new StringBuilder(29).append("/projects/").append(this.repoName()).append("/repository/commits").toString(), requestBody).doRequest(ClassTag$.MODULE$.apply(GitLabCommitResponse.class)).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$5).checkResponse("Error occured while trying to commit on GitLab")).map((Function1 & Serializable & scala.Serializable)x$6 -> (GitLabCommitResponse)x$6.getBody());
    }

    private Try<ResponseEntity<Void>> createTag(String tagName, String sha) {
        ScmHttpClientWrapper qual$1 = this.gitLabRequest().addQueryParam("tag_name", tagName).addQueryParam("ref", sha);
        String x$1 = new StringBuilder(26).append("/projects/").append(this.repoName()).append("/repository/tags").toString();
        Null$ x$2 = qual$1.post$default$2();
        return qual$1.post(x$1, null).doRequest(ClassTag$.MODULE$.apply(Void.class)).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$7).checkResponse("Error occurred while trying to create tag"));
    }

    private Try<GitLabCommitAction> createDslRequestAction(Blobs blobs) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ResponseEntity response = (ResponseEntity)this.gitLabRequest().addQueryParam("ref", $this.config.branch()).get(new StringBuilder(28).append("/projects/").append(this.repoName()).append("/repository/files/").append(this.urlEncode(blobs.filePath())).toString()).doRequest(ClassTag$.MODULE$.apply(Void.class)).get();
            HttpStatus httpStatus = response.getStatusCode();
            HttpStatus httpStatus2 = HttpStatus.UNAUTHORIZED;
            if (!(httpStatus != null ? !httpStatus.equals(httpStatus2) : httpStatus2 != null)) {
                throw new TemplateVersioningException("Unable to connect to the repository.", null, response.getStatusCodeValue());
            }
            return HttpClientRequest$.MODULE$.ResponseEntityExtension(response).isSuccessful();
        }).collect((PartialFunction)new scala.Serializable(null, blobs){
            public static final long serialVersionUID = 0L;
            private final Blobs blobs$2;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                GitLabCommitAction gitLabCommitAction = true == A1 ? new GitLabCommitAction("update", this.blobs$2.filePath(), Base64.getEncoder().encodeToString((byte[])this.blobs$2.dsl().getContent().apply()), "base64") : new GitLabCommitAction("create", this.blobs$2.filePath(), Base64.getEncoder().encodeToString((byte[])this.blobs$2.dsl().getContent().apply()), "base64");
                return (B1)gitLabCommitAction;
            }

            public final boolean isDefinedAt(boolean x1) {
                boolean bl = x1;
                boolean bl2 = bl ? true : true;
                return bl2;
            }
            {
                this.blobs$2 = blobs$2;
            }
        });
    }

    private Try<List<GitLabCommitAction>> createAttachmentsRequestAction(Blobs blobs) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            List list2;
            if (blobs.attachments().files().isEmpty()) {
                list2 = List$.MODULE$.empty();
            } else {
                Set set;
                ResponseEntity response = (ResponseEntity)this.gitLabRequest().addQueryParam("ref", $this.config.branch()).addQueryParam("path", blobs.attachments().folderName()).get(new StringBuilder(26).append("/projects/").append(this.repoName()).append("/repository/tree").toString()).doRequest(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(GitLabTree.class))).get();
                if (HttpClientRequest$.MODULE$.ResponseEntityExtension(response).isSuccessful()) {
                    set = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])response.getBody())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
                } else {
                    HttpStatus httpStatus = response.getStatusCode();
                    HttpStatus httpStatus2 = HttpStatus.NOT_FOUND;
                    if (!(httpStatus != null ? !httpStatus.equals(httpStatus2) : httpStatus2 != null)) {
                        set = Predef$.MODULE$.Set().empty();
                    } else {
                        throw new TemplateVersioningException("Unable to list repository tree", null, response.getStatusCodeValue());
                    }
                }
                Set existingAttachments = set;
                list2 = (List)blobs.attachments().files().view().filterNot((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)existingAttachments.contains((Object)file.fileName()))).foldLeft((Object)List$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(list, file) -> {
                    GitLabCommitAction gitLabCommitAction = new GitLabCommitAction("create", new StringBuilder(1).append(blobs.attachments().folderName()).append("/").append(file.fileName()).toString(), Base64.getEncoder().encodeToString((byte[])file.getContent().apply()), "base64");
                    return list.$colon$colon((Object)gitLabCommitAction);
                });
            }
            return list2;
        });
    }

    private String repoName() {
        return this.urlEncode(this.config.repository());
    }

    private String urlEncode(String value) {
        return UrlEscapers.urlPathSegmentEscaper().escape(value);
    }

    private ScmHttpClientWrapper gitLabRequest() {
        return HttpClientRequest$.MODULE$.newRequest(this.config.restApiUrl()).setUriEncoded(true).withAuth(this.config.credential());
    }

    public static final /* synthetic */ void $anonfun$testRepository$2(Void x$2) {
    }

    public static final /* synthetic */ boolean $anonfun$tagNotPresent$1(ResponseEntity x$4) {
        HttpStatus httpStatus = x$4.getStatusCode();
        HttpStatus httpStatus2 = HttpStatus.NOT_FOUND;
        return !(httpStatus != null ? !httpStatus.equals(httpStatus2) : httpStatus2 != null);
    }

    public GitLabScmConnector(GitLabScmConnectorConfig config) {
        this.config = config;
        super(config);
    }
}

