package com.xebialabs.xlrelease.triggers.config

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.events.XLReleaseEventBus
import com.xebialabs.xlrelease.quartz.config.QuartzConfiguration
import com.xebialabs.xlrelease.script.ScriptVariables
import com.xebialabs.xlrelease.script.jython.JythonScriptService
import com.xebialabs.xlrelease.service.{ConfigurationVariableService, ReleaseService}
import com.xebialabs.xlrelease.spring.config.{SqlConfiguration, SqlRepositoriesConfiguration}
import com.xebialabs.xlrelease.triggers.actors.{TriggerActorHolder, TriggerOperations}
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTriggerLifecycle
import com.xebialabs.xlrelease.triggers.events.handler.TriggerEventHandler
import com.xebialabs.xlrelease.triggers.scheduled.quartz.QuartzScheduledJobService
import com.xebialabs.xlrelease.triggers.scheduled.{ReleaseTriggerLifecycle, ScheduledJobService, TriggerScriptService}
import com.xebialabs.xlrelease.triggers.service.TriggerService
import com.xebialabs.xlrelease.triggers.service.impl._
import com.xebialabs.xlrelease.webhooks.mapping.PropertiesMapper
import com.xebialabs.xlrelease.webhooks.registry.SubscriberRegistry
import org.springframework.context.ApplicationContext
import org.springframework.context.annotation.{Bean, Configuration, Primary}

@Configuration
class TriggerExecutionConfiguration(applicationContext: ApplicationContext,
                                    sqlConfiguration: SqlConfiguration,
                                    triggerConfiguration: TriggerConfiguration,
                                    quartzConfiguration: QuartzConfiguration,
                                    sqlRepositories: SqlRepositoriesConfiguration,
                                    xlrConfig: XlrConfig,
                                    eventBus: XLReleaseEventBus,
                                    triggerActorHolder: TriggerActorHolder,
                                    jythonScriptService: JythonScriptService,
                                    releaseActorService: ReleaseActorService,
                                    releaseService: ReleaseService,
                                    subscriberRegistry: SubscriberRegistry,
                                    propertiesMapper: PropertiesMapper,
                                    scriptVariables: ScriptVariables,
                                    configurationVariableService: ConfigurationVariableService) {

  @Bean
  def triggerScriptService(): TriggerScriptService = {
    new TriggerScriptService(jythonScriptService, scriptVariables)
  }

  @Primary
  @Bean
  def triggerLifecycle(): DefaultTriggerLifecycle = {
    new DefaultTriggerLifecycle(List(releaseTriggerLifecycle(), eventBasedTriggerLifecycle()))
  }

  @Bean
  def releaseTriggerLifecycle(): ReleaseTriggerLifecycle = {
    new ReleaseTriggerLifecycle(scheduledJobService(), triggerScriptService(), releaseActorService, triggerService(), releaseService)
  }

  @Bean
  def eventBasedTriggerLifecycle(): EventBasedTriggerLifecycle = {
    new EventBasedTriggerLifecycle(applicationContext, subscriberRegistry, propertiesMapper)
  }

  @Bean
  def triggerOperations(): TriggerOperations = {
    new TriggerOperations(
      triggerConfiguration.triggerRepository(),
      sqlRepositories.releaseRepository(),
      eventBus,
      triggerLifecycle(),
      configurationVariableService
    )
  }

  @Bean
  def scheduledJobService(): ScheduledJobService = {
    new QuartzScheduledJobService(quartzConfiguration.scheduler())
  }

  @Bean
  def triggerService(): TriggerService = {
    new DefaultTriggerService(triggerActorHolder,
      xlrConfig,
      releaseService,
      sqlConfiguration.ciIdService(),
      triggerConfiguration.triggerRepository(),
      triggerConfiguration.triggerManagementRepository(),
      eventBus)
  }

  @Bean
  def triggerEventHandler(): TriggerEventHandler = {
    new TriggerEventHandler(
      triggerConfiguration.triggerRepository(),
      triggerConfiguration.triggerConfigurationReferencePersistence(),
      sqlConfiguration.ciIdService(),
      triggerService(),
      triggerLifecycle())
  }

}
