/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.event_based.validators;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger;
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty;
import com.xebialabs.xlrelease.webhooks.mapping.PropertyAddress$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005M3A!\u0002\u0004\u0001'!)A\u0006\u0001C\u0001[!)\u0001\u0007\u0001C!c!)q\b\u0001C\u0005\u0001\")1\n\u0001C\u0005\u0019\nQRI^3oi\n\u000b7/\u001a3Ue&<w-\u001a:WC2LG-\u0019;pe*\u0011q\u0001C\u0001\u000bm\u0006d\u0017\u000eZ1u_J\u001c(BA\u0005\u000b\u0003-)g/\u001a8u?\n\f7/\u001a3\u000b\u0005-a\u0011\u0001\u0003;sS\u001e<WM]:\u000b\u00055q\u0011!\u0003=me\u0016dW-Y:f\u0015\ty\u0001#A\u0005yK\nL\u0017\r\\1cg*\t\u0011#A\u0002d_6\u001c\u0001aE\u0002\u0001)q\u0001\"!\u0006\u000e\u000e\u0003YQ!a\u0006\r\u0002\t1\fgn\u001a\u0006\u00023\u0005!!.\u0019<b\u0013\tYbC\u0001\u0004PE*,7\r\u001e\t\u0004;\u0019BS\"\u0001\u0010\u000b\u0005}\u0001\u0013A\u0003<bY&$\u0017\r^5p]*\u0011\u0011EI\u0001\u0004CBL'BA\u0012%\u0003\u0019\u0001H.^4j]*\u0011QED\u0001\tI\u0016\u0004Hn\\=ji&\u0011qE\b\u0002\n-\u0006d\u0017\u000eZ1u_J\u0004\"!\u000b\u0016\u000e\u0003!I!a\u000b\u0005\u0003#\u00153XM\u001c;CCN,G\r\u0016:jO\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0002]A\u0011q\u0006A\u0007\u0002\r\u0005Aa/\u00197jI\u0006$X\rF\u00023qi\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012A!\u00168ji\")\u0011H\u0001a\u0001Q\u00059AO]5hO\u0016\u0014\b\"B\u001e\u0003\u0001\u0004a\u0014aB2p]R,\u0007\u0010\u001e\t\u0003;uJ!A\u0010\u0010\u0003#Y\u000bG.\u001b3bi&|gnQ8oi\u0016DH/\u0001\u0010d_:$\u0018-\u001b8t\u001b\u0006dgm\u001c:nK\u00124\u0016M]5bE2,g*Y7fgR\u0011\u0011\t\u0012\t\u0003g\tK!a\u0011\u001b\u0003\u000f\t{w\u000e\\3b]\")\u0011h\u0001a\u0001\u000bB\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nD\u0001\u0007I>l\u0017-\u001b8\n\u0005);%a\u0002+sS\u001e<WM]\u0001!G\",7m[%om\u0006d\u0017\u000eZ'baB,G\r\u0015:pa\u0016\u0014H/\u001f,bYV,7\u000fF\u00023\u001b:CQ!\u000f\u0003A\u0002!BQa\u0014\u0003A\u0002A\u000bq\"\u001a=uK:$W\rZ\"p]R,\u0007\u0010\u001e\t\u0003;EK!A\u0015\u0010\u00033\u0015CH/\u001a8eK\u00124\u0016\r\\5eCRLwN\\\"p]R,\u0007\u0010\u001e")
public class EventBasedTriggerValidator
implements Validator<EventBasedTrigger> {
    public void validate(EventBasedTrigger trigger, ValidationContext context) {
        ExtendedValidationContext extendedContext = (ExtendedValidationContext)context;
        String templateId = (String)trigger.getTemplateId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        String releaseTitle = (String)CollectionConverters$.MODULE$.ListHasAsScala(trigger.mappedProperties()).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EventBasedTriggerValidator.$anonfun$validate$1(x$1))).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends MappedProperty, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof MappedProperty.StringValue) {
                    MappedProperty.StringValue stringValue = (MappedProperty.StringValue)A1;
                    return (B1)stringValue.value();
                }
                if (A1 instanceof MappedProperty.PropertyValue) {
                    MappedProperty.PropertyValue propertyValue = (MappedProperty.PropertyValue)A1;
                    return (B1)propertyValue.sourceProperty();
                }
                if (A1 instanceof MappedProperty.VariableValue) {
                    MappedProperty.VariableValue variableValue = (MappedProperty.VariableValue)A1;
                    return (B1)variableValue.variableKey();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(MappedProperty x1) {
                MappedProperty mappedProperty = x1;
                if (mappedProperty instanceof MappedProperty.StringValue) {
                    return true;
                }
                if (mappedProperty instanceof MappedProperty.PropertyValue) {
                    return true;
                }
                return mappedProperty instanceof MappedProperty.VariableValue;
            }
        }).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        EventBasedTriggerValidator.checkTemplatePresence$1(templateId, extendedContext, trigger);
        EventBasedTriggerValidator.checkTemplateFolderAndTriggerFolderMatch$1(trigger, templateId, extendedContext);
        EventBasedTriggerValidator.checkTriggerFolderAndSourceFolderMatch$1(trigger, extendedContext);
        EventBasedTriggerValidator.checkReleaseTitlePresence$1(releaseTitle, extendedContext, trigger);
        this.checkMalformedVariableNamesInMappings$1(trigger, extendedContext);
        this.checkInvalidMappedPropertyValues(trigger, extendedContext);
        EventBasedTriggerValidator.checkFilterIsValid$1(trigger, extendedContext);
    }

    private boolean containsMalformedVariableNames(Trigger trigger) {
        Regex badVarNamePatter = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("variables\\[(.*(\\[|\\]).*)\\]"));
        return CollectionConverters$.MODULE$.ListHasAsScala(((EventBasedTrigger)trigger).mappedProperties()).asScala().exists((Function1 & Serializable)mappedProp -> BoxesRunTime.boxToBoolean((boolean)EventBasedTriggerValidator.$anonfun$containsMalformedVariableNames$1(badVarNamePatter, mappedProp)));
    }

    private void checkInvalidMappedPropertyValues(EventBasedTrigger trigger, ExtendedValidationContext extendedContext) {
        Buffer invalidPropertyValues = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(trigger.mappedProperties()).asScala().collect((PartialFunction)new Serializable(null, trigger){
            private static final long serialVersionUID = 0L;
            private final EventBasedTrigger trigger$2;

            public final <A1 extends MappedProperty, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof MappedProperty.PropertyValue) {
                    MappedProperty.PropertyValue propertyValue = (MappedProperty.PropertyValue)A1;
                    if (!PropertyAddress$.MODULE$.hasProperty(Type.valueOf((String)this.trigger$2.eventType()), PropertyAddress$.MODULE$.apply(propertyValue.sourceProperty()))) {
                        return (B1)propertyValue;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(MappedProperty x1) {
                MappedProperty mappedProperty = x1;
                if (mappedProperty instanceof MappedProperty.PropertyValue) {
                    MappedProperty.PropertyValue propertyValue = (MappedProperty.PropertyValue)mappedProperty;
                    if (!PropertyAddress$.MODULE$.hasProperty(Type.valueOf((String)this.trigger$2.eventType()), PropertyAddress$.MODULE$.apply(propertyValue.sourceProperty()))) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.trigger$2 = trigger$2;
            }
        });
        if (invalidPropertyValues.nonEmpty()) {
            extendedContext.focus((ConfigurationItem)trigger, "mappedProperties").error(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Mapped properties contain references to non-existing event properties:\n            |" + ((IterableOnceOps)invalidPropertyValues.map((Function1 & Serializable)pv -> "'" + trigger.eventType() + "' has no '" + pv.sourceProperty() + "'")).mkString(",\n"))), new Object[0]);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(MappedProperty x$1) {
        String string = x$1.targetProperty();
        String string2 = "releaseTitle";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final void checkTemplatePresence$1(String templateId$1, ExtendedValidationContext extendedContext$1, EventBasedTrigger trigger$1) {
        if (Strings.isNullOrEmpty((String)templateId$1)) {
            extendedContext$1.error((ConfigurationItem)trigger$1, "templateId", "Trigger does not have associated template", new Object[0]);
            return;
        }
    }

    private static final void checkTemplateFolderAndTriggerFolderMatch$1(EventBasedTrigger trigger$1, String templateId$1, ExtendedValidationContext extendedContext$1) {
        if (!Strings.isNullOrEmpty((String)trigger$1.getFolderId()) && !Strings.isNullOrEmpty((String)templateId$1)) {
            String string = Ids.findFolderId((String)templateId$1);
            String string2 = trigger$1.getFolderId();
            if (string == null ? string2 != null : !string.equals(string2)) {
                extendedContext$1.error((ConfigurationItem)trigger$1, "templateId", "Trigger folder id does not match template folder id", new Object[0]);
                return;
            }
        }
    }

    private static final void checkTriggerFolderAndSourceFolderMatch$1(EventBasedTrigger trigger$1, ExtendedValidationContext extendedContext$1) {
        if (trigger$1.eventSource() != null) {
            String folderId = (String)trigger$1.eventSource().getProperty("folderId");
            if (!(Strings.isNullOrEmpty((String)trigger$1.getFolderId()) || Strings.isNullOrEmpty((String)folderId) || trigger$1.getFolderId().contains(Ids.getName((String)folderId)))) {
                extendedContext$1.error((ConfigurationItem)trigger$1, "eventSource", "Couldn't set eventSource that doesn't belong to the folder['" + trigger$1.getFolderId() + "']", new Object[0]);
                return;
            }
            return;
        }
    }

    private static final void checkReleaseTitlePresence$1(String releaseTitle$1, ExtendedValidationContext extendedContext$1, EventBasedTrigger trigger$1) {
        if (Strings.isNullOrEmpty((String)releaseTitle$1)) {
            extendedContext$1.error((ConfigurationItem)trigger$1, "releaseTitle", "Release title is required", new Object[0]);
            return;
        }
    }

    private final void checkMalformedVariableNamesInMappings$1(EventBasedTrigger trigger$1, ExtendedValidationContext extendedContext$1) {
        if (trigger$1.isEnabled() && this.containsMalformedVariableNames(trigger$1)) {
            extendedContext$1.focus((ConfigurationItem)trigger$1, "mappedProperties").error(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("There is an issue with the name of one or more variables.\n             | Please update the variable names and save the trigger again.\n             | The trigger will be disabled until the issue is fixed.")), new Object[0]);
            return;
        }
    }

    private static final void checkFilterIsValid$1(EventBasedTrigger trigger$1, ExtendedValidationContext extendedContext$1) {
        if (trigger$1.getEventFilter() != null) {
            trigger$1.getEventFilter().validate(extendedContext$1);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$containsMalformedVariableNames$1(Regex badVarNamePatter$1, MappedProperty mappedProp) {
        Option option = badVarNamePatter$1.findFirstMatchIn((CharSequence)mappedProp.targetProperty());
        if (option instanceof Some) {
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }
}

