/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.scheduled.validators;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.xlrelease.configuration.FeatureSettings;
import com.xebialabs.xlrelease.domain.PollType;
import com.xebialabs.xlrelease.domain.ScheduledTrigger;
import com.xebialabs.xlrelease.triggers.scheduled.validators.ScheduledTriggerValidator$;
import com.xebialabs.xlrelease.utils.Limits$;
import com.xebialabs.xlrelease.utils.QuartzUtils;
import com.xebialabs.xlrelease.utils.QuartzUtils$;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTime;
import org.quartz.CronExpression;
import org.springframework.context.ApplicationContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015r!B\u0006\r\u0011\u0003Ib!B\u000e\r\u0011\u0003a\u0002\"B\u0018\u0002\t\u0003\u0001\u0004bB\u0019\u0002\u0005\u0004%\tA\r\u0005\u0007s\u0005\u0001\u000b\u0011B\u001a\t\u0011i\n\u0001R1A\u0005\nm2Aa\u0007\u0007\u0001\u0005\")qF\u0002C\u0001+\")qK\u0002C!1\")1M\u0002C\u0005I\")!P\u0002C\u0001w\u0006I2k\u00195fIVdW\r\u001a+sS\u001e<WM\u001d,bY&$\u0017\r^8s\u0015\tia\"\u0001\u0006wC2LG-\u0019;peNT!a\u0004\t\u0002\u0013M\u001c\u0007.\u001a3vY\u0016$'BA\t\u0013\u0003!!(/[4hKJ\u001c(BA\n\u0015\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0016-\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002/\u0005\u00191m\\7\u0004\u0001A\u0011!$A\u0007\u0002\u0019\tI2k\u00195fIVdW\r\u001a+sS\u001e<WM\u001d,bY&$\u0017\r^8s'\r\tQ$\n\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\nA\u0001\\1oO*\t!%\u0001\u0003kCZ\f\u0017B\u0001\u0013 \u0005\u0019y%M[3diB\u0011a%L\u0007\u0002O)\u0011\u0001&K\u0001\u0007gB\u0014\u0018N\\4\u000b\u0005)Z\u0013\u0001B1lW\u0006T!\u0001\f\n\u0002\u000fM,\b\u000f]8si&\u0011af\n\u0002\u0015'\u000e\fG.Y*qe&tw-Q<be\u0016\u0014U-\u00198\u0002\rqJg.\u001b;?)\u0005I\u0012\u0001\b(V\u001b\n+%kX(G?&sE+\u0012*W\u00032\u001bv\fV(`\u0007\"+5iS\u000b\u0002gA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t\u0019\u0011J\u001c;\u0002;9+VJQ#S?>3u,\u0013(U\u000bJ3\u0016\tT*`)>{6\tS#D\u0017\u0002\nAcY8oM&<WO]1uS>t7+\u001a:wS\u000e,W#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\u0012\u0012aB:feZL7-Z\u0005\u0003\u0003z\u0012AcQ8oM&<WO]1uS>t7+\u001a:wS\u000e,7c\u0001\u0004\u001e\u0007B\u0019A)T(\u000e\u0003\u0015S!AR$\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002I\u0013\u0006\u0019\u0011\r]5\u000b\u0005)[\u0015A\u00029mk\u001eLgN\u0003\u0002M)\u0005AA-\u001a9m_fLG/\u0003\u0002O\u000b\nIa+\u00197jI\u0006$xN\u001d\t\u0003!Nk\u0011!\u0015\u0006\u0003%J\ta\u0001Z8nC&t\u0017B\u0001+R\u0005A\u00196\r[3ek2,G\r\u0016:jO\u001e,'\u000fF\u0001W!\tQb!\u0001\u0005wC2LG-\u0019;f)\rIFL\u0018\t\u0003iiK!aW\u001b\u0003\tUs\u0017\u000e\u001e\u0005\u0006;\"\u0001\raT\u0001\biJLwmZ3s\u0011\u0015y\u0006\u00021\u0001a\u0003\u001d\u0019wN\u001c;fqR\u0004\"\u0001R1\n\u0005\t,%!\u0005,bY&$\u0017\r^5p]\u000e{g\u000e^3yi\u0006aa/\u00197jI\u0006$Xm\u0011:p]R)\u0011,\u001a:uk\")a-\u0003a\u0001O\u0006QQ\r\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005!|gBA5n!\tQW'D\u0001l\u0015\ta\u0007$\u0001\u0004=e>|GOP\u0005\u0003]V\na\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\u0019\u0019FO]5oO*\u0011a.\u000e\u0005\u0006g&\u0001\raM\u0001\u0006Y&l\u0017\u000e\u001e\u0005\u0006;&\u0001\ra\u0014\u0005\u0006m&\u0001\ra^\u0001\u0010Kb$XM\u001c3fI\u000e{g\u000e^3yiB\u0011A\t_\u0005\u0003s\u0016\u0013\u0011$\u0012=uK:$W\r\u001a,bY&$\u0017\r^5p]\u000e{g\u000e^3yi\u0006\u0001\u0013M]3OKb$\u0018J\u001c;feZ\fGn]*i_J$XM\u001d+iC:d\u0015.\\5u)\u0019ax0a\u0005\u0002$A\u0011A'`\u0005\u0003}V\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0002)\u0001\r!a\u0001\u0002\u001d\r\u0014xN\\#yaJ,7o]5p]B!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011AB9vCJ$(P\u0003\u0002\u0002\u000e\u0005\u0019qN]4\n\t\u0005E\u0011q\u0001\u0002\u000f\u0007J|g.\u0012=qe\u0016\u001c8/[8o\u0011\u001d\t)B\u0003a\u0001\u0003/\t\u0011b\u001d;beR$\u0016.\\3\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b\"\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u00121\u0004\u0002\u0005\t\u0006$X\rC\u0003t\u0015\u0001\u00071\u0007")
public class ScheduledTriggerValidator
implements Validator<ScheduledTrigger> {
    public static int NUMBER_OF_INTERVALS_TO_CHECK() {
        return ScheduledTriggerValidator$.MODULE$.NUMBER_OF_INTERVALS_TO_CHECK();
    }

    public static void setApplicationContext(ApplicationContext x$1) {
        ScheduledTriggerValidator$.MODULE$.setApplicationContext(x$1);
    }

    public static ApplicationContext getApplicationContext() {
        return ScheduledTriggerValidator$.MODULE$.getApplicationContext();
    }

    public static void applicationContext_$eq(ApplicationContext x$1) {
        ScheduledTriggerValidator$.MODULE$.applicationContext_$eq(x$1);
    }

    public static ApplicationContext applicationContext() {
        return ScheduledTriggerValidator$.MODULE$.applicationContext();
    }

    public static <T> Map<String, T> springBeans(ClassTag<T> evidence$3) {
        return ScheduledTriggerValidator$.MODULE$.springBeans(evidence$3);
    }

    public static <T> T springBean(String name, ClassTag<T> evidence$2) {
        return ScheduledTriggerValidator$.MODULE$.springBean(name, evidence$2);
    }

    public static <T> T springBean(ClassTag<T> evidence$1) {
        return ScheduledTriggerValidator$.MODULE$.springBean(evidence$1);
    }

    public void validate(ScheduledTrigger trigger, ValidationContext context) {
        FeatureSettings limits = ScheduledTriggerValidator$.MODULE$.com$xebialabs$xlrelease$triggers$scheduled$validators$ScheduledTriggerValidator$$configurationService().getFeatureSettings(Limits$.MODULE$.TYPE_LIMITS());
        int minTriggerInterval = BoxesRunTime.unboxToInt((Object)limits.getProperty(Limits$.MODULE$.MIN_TRIGGER_INTERVAL()));
        boolean limitsEnabled = BoxesRunTime.unboxToBoolean((Object)limits.getProperty(Limits$.MODULE$.ENABLED()));
        ExtendedValidationContext extendedContext = (ExtendedValidationContext)context;
        PollType pollType = trigger.getPollType();
        if (PollType.REPEAT.equals(pollType)) {
            int period = NumberUtils.toInt((String)trigger.getPeriodicity(), (int)0);
            if (period <= 0) {
                extendedContext.error((ConfigurationItem)trigger, "periodicity", "Trigger has wrong periodicity '" + trigger.getPeriodicity() + "'", new Object[0]);
                return;
            }
            if (limitsEnabled && period < minTriggerInterval) {
                extendedContext.error((ConfigurationItem)trigger, "periodicity", "Trigger must not fire more frequently than once per " + minTriggerInterval + " seconds", new Object[0]);
                return;
            }
            return;
        }
        if (PollType.CRON.equals(pollType)) {
            String cron = trigger.getPeriodicity();
            String errorMsg = "Trigger has wrong cron expression '" + cron + "'";
            if (StringUtils.isBlank((CharSequence)cron)) {
                extendedContext.error((ConfigurationItem)trigger, "periodicity", errorMsg, new Object[0]);
                return;
            }
            if (!CronExpression.isValidExpression((String)QuartzUtils.QuartzCron$.MODULE$.asQuartzCron$extension(QuartzUtils$.MODULE$.QuartzCron(cron)))) {
                extendedContext.error((ConfigurationItem)trigger, "periodicity", errorMsg, new Object[0]);
                return;
            }
            if (limitsEnabled) {
                this.validateCron(cron, minTriggerInterval, trigger, extendedContext);
                return;
            }
            return;
        }
        throw new MatchError((Object)pollType);
    }

    private void validateCron(String expression, int limit, ScheduledTrigger trigger, ExtendedValidationContext extendedContext) {
        DateTime today;
        CronExpression cronExpression = new CronExpression(QuartzUtils.QuartzCron$.MODULE$.asQuartzCron$extension(QuartzUtils$.MODULE$.QuartzCron(expression)));
        boolean intervalsLongerThanLimit = this.areNextIntervalsShorterThanLimit(cronExpression, (today = new DateTime().withTimeAtStartOfDay()).toDate(), limit);
        if (!intervalsLongerThanLimit) {
            extendedContext.error((ConfigurationItem)trigger, "periodicity", "Trigger must not fire more frequently than once per " + limit + " seconds", new Object[0]);
            return;
        }
    }

    public boolean areNextIntervalsShorterThanLimit(CronExpression cronExpression, Date startTime, int limit) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ObjectRef reference = ObjectRef.create((Object)cronExpression.getNextValidTimeAfter(startTime));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), ScheduledTriggerValidator$.MODULE$.NUMBER_OF_INTERVALS_TO_CHECK()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                int n = x$1;
                Date nextTime = cronExpression.getNextValidTimeAfter((Date)reference$1.elem);
                int interval = (int)((nextTime.getTime() - ((Date)reference$1.elem).getTime()) / 1000L);
                if (interval < limit) {
                    throw new RuntimeException();
                }
                reference$1.elem = nextTime;
            });
        }).isSuccess();
    }
}

