package com.xebialabs.xlrelease.triggers.service

import com.xebialabs.xlrelease.actors.initializer.SubscriptionInitializer
import org.springframework.core.Ordered.LOWEST_PRECEDENCE
import org.springframework.jms.config.JmsListenerEndpointRegistry
import org.springframework.stereotype.Component
import scala.jdk.CollectionConverters._

@Component
class JmsListenersInitializer (
                                jmsListenerEndpointRegistry: JmsListenerEndpointRegistry
                              ) extends SubscriptionInitializer {
  override def initialize(): Unit = {
    jmsListenerEndpointRegistry.getListenerContainers.asScala.foreach(_.start())
  }

  override def getOrder: Int = LOWEST_PRECEDENCE
}
