/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.service;

import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.service.FolderOperationValidator;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001B\u0004\t\u0001MA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)!\u0007\u0001C\u0001g!)\u0001\b\u0001C!s!)!\r\u0001C!G\")a\r\u0001C\u0005O\nyBK]5hO\u0016\u0014hi\u001c7eKJ|\u0005/\u001a:bi&|gNV1mS\u0012\fGo\u001c:\u000b\u0005%Q\u0011aB:feZL7-\u001a\u0006\u0003\u00171\t\u0001\u0002\u001e:jO\u001e,'o\u001d\u0006\u0003\u001b9\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005=\u0001\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005\t\u0012aA2p[\u000e\u00011\u0003\u0002\u0001\u00155}\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007CA\u000e\u001e\u001b\u0005a\"BA\u0005\r\u0013\tqBD\u0001\rG_2$WM](qKJ\fG/[8o-\u0006d\u0017\u000eZ1u_J\u0004\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u000bMdg\r\u000e6\u000b\u0003\u0011\n\u0001b\u001a:jujdW\rZ\u0005\u0003M\u0005\u0012q\u0001T8hO&tw-A\fd_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\u0006L\u0007\u0002U)\u00111\u0006D\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0017+\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u00180A\tue&<w-\u001a:SKB|7/\u001b;pef\u0004\"!\u000b\u0019\n\u0005ER#!\u0005+sS\u001e<WM\u001d*fa>\u001c\u0018\u000e^8ss\u00061A(\u001b8jiz\"2\u0001\u000e\u001c8!\t)\u0004!D\u0001\t\u0011\u001593\u00011\u0001)\u0011\u0015q3\u00011\u00010\u0003U1\u0018\r\\5eCR,Wj\u001c<f\u001fB,'/\u0019;j_:$BAO\u001fK\u0019B\u0011QcO\u0005\u0003yY\u0011A!\u00168ji\")a\b\u0002a\u0001\u007f\u0005Aam\u001c7eKJLE\r\u0005\u0002A\u000f:\u0011\u0011)\u0012\t\u0003\u0005Zi\u0011a\u0011\u0006\u0003\tJ\ta\u0001\u0010:p_Rt\u0014B\u0001$\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001*\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u00193\u0002\"B&\u0005\u0001\u0004y\u0014a\u00038foB\u000b'/\u001a8u\u0013\u0012DQ!\u0014\u0003A\u00029\u000b\u0001\"\\3tg\u0006<Wm\u001d\t\u0004\u001fR3V\"\u0001)\u000b\u0005E\u0013\u0016\u0001B;uS2T\u0011aU\u0001\u0005U\u00064\u0018-\u0003\u0002V!\n!A*[:u!\t9\u0006-D\u0001Y\u0015\tI&,\u0001\u0006wC2LG-\u0019;j_:T!a\u0017/\u0002\u0007\u0005\u0004\u0018N\u0003\u0002^=\u00061\u0001\u000f\\;hS:T!a\u0018\b\u0002\u0011\u0011,\u0007\u000f\\8zSRL!!\u0019-\u0003#Y\u000bG.\u001b3bi&|g.T3tg\u0006<W-A\fwC2LG-\u0019;f\t\u0016dW\r^3Pa\u0016\u0014\u0018\r^5p]R\u0019!\bZ3\t\u000by*\u0001\u0019A \t\u000b5+\u0001\u0019\u0001(\u0002M\u001d,GOT8o\u0013:DWM]5uK\u00124u\u000e\u001c3feR\u0013\u0018nZ4feJ+g-\u001a:f]\u000e,7\u000fF\u0002im^\u00042!\u001b8q\u001b\u0005Q'BA6m\u0003\u001diW\u000f^1cY\u0016T!!\u001c\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002pU\n\u00191+\u001a;\u0011\u0005E$X\"\u0001:\u000b\u0005Md\u0011A\u00023p[\u0006Lg.\u0003\u0002ve\n\t\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000by2\u0001\u0019A \t\u000ba4\u0001\u0019A \u0002\u00179,wOZ8mI\u0016\u0014\u0018\n\u001a\u0015\u0003\u0001i\u00042a_A\u0003\u001b\u0005a(BA?\u007f\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0004\u007f\u0006\u0005\u0011aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005\r\u0011aA8sO&\u0019\u0011q\u0001?\u0003\u0013\r{W\u000e]8oK:$\b")
public class TriggerFolderOperationValidator
implements FolderOperationValidator,
Logging {
    private final ConfigurationRepository configurationRepository;
    private final TriggerRepository triggerRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerFolderOperationValidator triggerFolderOperationValidator = this;
        synchronized (triggerFolderOperationValidator) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public void validateMoveOperation(String folderId, String newParentId, List<ValidationMessage> messages) {
        Set<BaseConfiguration> invalidRefs = this.getNonInheritedFolderTriggerReferences(folderId, newParentId);
        if (invalidRefs.nonEmpty()) {
            ValidationMessage errorMessage = ValidationMessage.error((String)folderId, (String)"configuration references for triggers", (String)("configuration references for triggers not inherited by the destination folder: " + ((IterableOnceOps)invalidRefs.map((Function1 & Serializable)x$1 -> x$1.getTitle())).mkString("\"", "\", \"", "\"")));
            messages.add(errorMessage);
            return;
        }
    }

    public void validateDeleteOperation(String folderId, List<ValidationMessage> messages) {
        PageRequest all = PageRequest.of((int)0, (int)Integer.MAX_VALUE);
        Seq triggers = CollectionConverters$.MODULE$.ListHasAsScala(this.triggerRepository.findByFolderId(folderId, true, (Pageable)all).getContent()).asScala().toSeq();
        Seq enabledTriggers = (Seq)triggers.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.isEnabled()));
        if (enabledTriggers.nonEmpty()) {
            ValidationMessage errorMessage = ValidationMessage.error((String)folderId, (String)"active triggers", (String)("active triggers, please disable the following triggers before continuing: " + ((IterableOnceOps)enabledTriggers.map((Function1 & Serializable)x$2 -> x$2.getTitle())).mkString("\"", "\", \"", "\"")));
            messages.add(errorMessage);
            return;
        }
    }

    private Set<BaseConfiguration> getNonInheritedFolderTriggerReferences(String folderId, String newfolderId) {
        Seq nonInheritedConfIds = this.configurationRepository.findAllNonInheritedTriggerReferences(folderId);
        Set res = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        nonInheritedConfIds.foreach((Function1 & Serializable)confId -> {
            BaseConfiguration c = $this.configurationRepository.read(confId);
            if (c.getFolderId() != null && !newfolderId.startsWith(c.getFolderId()) && !c.getFolderId().startsWith(folderId)) {
                return BoxesRunTime.boxToBoolean((boolean)res.add((Object)c));
            }
            return BoxedUnit.UNIT;
        });
        return res;
    }

    public TriggerFolderOperationValidator(ConfigurationRepository configurationRepository, TriggerRepository triggerRepository) {
        this.configurationRepository = configurationRepository;
        this.triggerRepository = triggerRepository;
        Logging.$init$((Logging)this);
    }
}

