package com.xebialabs.xlrelease.triggers.service.impl

import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext
import com.xebialabs.xlrelease.domain.{ReleaseTrigger, Trigger}
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.security.PermissionCheckerHolder
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger

import scala.util.Try

class TriggerReferencedPermissionsValidator {
  def validate(trigger: Trigger, context: ExtendedValidationContext): Unit = {
    val releaseFolderId = getReleaseFolderId(trigger).orNull
    for {
      templateId <- getTemplateId(trigger)
      targetFolderId <- if (Ids.isNullId(releaseFolderId)) Option(Ids.findFolderId(templateId)) else Option(releaseFolderId)
    } yield {
      Try(PermissionCheckerHolder.get().checkIsAllowedToCreateReleaseFromTemplate(templateId, targetFolderId))
        .recover {
          case ex => context.error(trigger, "templateId", ex.getMessage)
        }
    }
  }

  private def getReleaseFolderId(trigger: Trigger): Option[String] = {
    trigger match {
      case rt: ReleaseTrigger => Option(rt.getReleaseFolder)
      case et: EventBasedTrigger => et.getReleaseFolderId
      case _ => None
    }
  }

  private def getTemplateId(trigger: Trigger): Option[String] = {
    trigger match {
      case rt: ReleaseTrigger => Option(rt.getTemplate)
      case et: EventBasedTrigger => et.getTemplateId
      case _ => None
    }
  }
}
