package com.xebialabs.xlrelease.triggers.actors

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.support.pekko.spring.SpringActor
import com.xebialabs.xlrelease.triggers.actors.TriggerActor.TriggerAction
import org.apache.pekko.actor.{Actor, ActorLogging, ActorRef}

object TriggerProcessingActor {
  def name = "trigger-processing-actor"
}

@SpringActor
class TriggerProcessingActor(xlrConfig: XlrConfig, triggerOperations: TriggerOperations) extends Actor with ActorLogging {
  private def createOrFind(triggerId: String, msg: AnyRef): ActorRef = {
    context.child(triggerId.triggerActorName).getOrElse {
      log.debug(s"TriggerProcessingActor - creating an actor tree for $triggerId (triggered by $msg)")
      context.actorOf(
        TriggerActor.props(xlrConfig, triggerOperations),
        triggerId.triggerActorName
      )
    }
  }

  override def receive: Receive = {
    case msg: TriggerAction => createOrFind(msg.triggerId, msg) forward msg
  }

}
