package com.xebialabs.xlrelease

import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter
import com.xebialabs.xlrelease.domain.Trigger
import com.xebialabs.xlrelease.serialization.json.xltype.CiJson2Writer

package object triggers {
  implicit class TriggerExtensions(trigger: Trigger) {
    def toJson: String = {
      if (trigger != null) {
        val converter = new WriteWithoutPasswordCiConverter
        val jsonWriter = new CiJson2Writer()
        converter.writeCi(trigger, jsonWriter, Int.MaxValue)
        jsonWriter.getWriter.toString
      } else {
        null
      }
    }
  }

}
