package com.xebialabs.xlrelease.triggers.scheduled.validators

import com.google.common.base.Strings.isNullOrEmpty
import com.xebialabs.deployit.plugin.api.validation.{ExtendedValidationContext, ValidationContext, Validator}
import com.xebialabs.xlrelease.domain.Trigger
import com.xebialabs.xlrelease.repository.sql.persistence

class TriggerValidator extends Validator[Trigger] {
  override def validate(trigger: Trigger, context: ValidationContext): Unit = {
    val extendedContext = context.asInstanceOf[ExtendedValidationContext]
    if (isNullOrEmpty(trigger.getTitle)) {
      extendedContext.error(trigger, "title", s"Trigger title cannot be blank")
    }
    if (!isNullOrEmpty(trigger.getTitle) && trigger.getTitle.length > persistence.LONG_VARCHAR_LENGTH) {
      extendedContext.error(trigger, "title",
        s"Trigger title must be ${persistence.LONG_VARCHAR_LENGTH} characters or less")
    }
    if (!isNullOrEmpty(trigger.getDescription) && trigger.getDescription.length > persistence.LONG_VARCHAR_LENGTH) {
      extendedContext.error(trigger, "description",
        s"Description must be ${persistence.LONG_VARCHAR_LENGTH} characters or less")
    }
    if (isNullOrEmpty(trigger.getFolderId)) {
      extendedContext.error(trigger, "folderId", s"Trigger does not belong to any folder")
    }
  }
}
