package com.xebialabs.xlrelease.triggers.action

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.triggers.deployment_based.StatusWebhookTrigger
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger

import scala.beans.BeanProperty

sealed trait TriggerActionResult

case class TriggerActionSkipped(message: String) extends TriggerActionResult

// todo maybe use type parameter
case class TriggerActionExecuted(result: String) extends TriggerActionResult

@Metadata(virtual = true)
trait TriggerAction extends BaseConfigurationItem {

  @BeanProperty
  @Property
  var triggerId: String = _

  def run(): TriggerActionResult

  def init(trigger: EventBasedTrigger): Unit

  def init(trigger: StatusWebhookTrigger): Unit
}
