package com.xebialabs.xlrelease.triggers.api.form

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.xebialabs.xlrelease.serialization.json.jackson.CiDeserializer
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger

import scala.beans.BeanProperty

@JsonIgnoreProperties(ignoreUnknown = true)
class EventBasedTriggerTestRunForm {
  @BeanProperty
  @JsonDeserialize(using = classOf[CiDeserializer])
  var trigger: EventBasedTrigger = _

  @BeanProperty
  var event: HttpRequestEventForm = _
}

@JsonIgnoreProperties(ignoreUnknown = true)
class HttpRequestEventForm {
  @BeanProperty
  var headers: java.util.Map[String, String] = _

  @BeanProperty
  var parameters: java.util.Map[String, String] = _

  @BeanProperty
  var content: String = _
}
