package com.xebialabs.xlrelease.triggers.deployment_based

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.triggers.AbstractEventTrigger
import com.xebialabs.xlrelease.triggers.validators.StatusWebhookTriggerRule
import com.xebialabs.xlrelease.webhooks.consumers.StatusWebhookEventSource
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty.StringValue

import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._

@StatusWebhookTriggerRule
@Metadata(virtual = false, label = "Deployment event trigger")
class StatusWebhookTrigger extends AbstractEventTrigger {

  @BeanProperty
  @Property(label = "Event source", description = "Event source on which the trigger listens")
  var endpoint: StatusWebhookEventSource = _


  def getReleaseTitle: Option[String] = {
    mappedProperties.asScala.find(_.targetProperty == "releaseTitle").collect {
      case s: StringValue => s.value
    }
  }

  def getApplicationTitle: String = {
    val title = syntheticProperties.get("applicationTitle")
    if (title == null) {
      ""
    } else {
      title.toString
    }
  }

  def getEnvironmentTitle: String = {
   val env = syntheticProperties.get("environmentTitle")
    if (env == null) {
      ""
    } else {
      env.toString
    }
  }

  def getAppVersion: String = {
    val version = syntheticProperties.get("applicationVersion")
    if (version == null) {
      ""
    } else {
      version.toString
    }
  }

  def getDeploymentStatuses: Set[String] = {
    val setString = syntheticProperties.get("deploymentStatuses").toString.toLowerCase
    val statuses = setString.substring(setString.indexOf("[") + 1, setString.lastIndexOf("]")).split(",").map(_.trim).toSet
    statuses
  }
}
