package com.xebialabs.xlrelease.triggers.deployment_based

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.Trigger
import com.xebialabs.xlrelease.events.XLReleaseEventBus
import com.xebialabs.xlrelease.repository.{ReleaseRepository, TriggerRepository}
import com.xebialabs.xlrelease.triggers.action.TriggerAction
import com.xebialabs.xlrelease.triggers.actors.{TriggerExecutionResult, TriggerLifecycle}
import com.xebialabs.xlrelease.triggers.event_based.{EventBasedTriggerConsumer, EventBasedTriggerExecutionContext}
import com.xebialabs.xlrelease.triggers.service.impl.TriggerExecutionContext
import com.xebialabs.xlrelease.webhooks.mapping.PropertiesMapper
import com.xebialabs.xlrelease.webhooks.registry.SubscriberRegistry
import grizzled.slf4j.Logging
import org.springframework.context.ApplicationContext

class StatusWebhookTriggerLifecycle(applicationContext: ApplicationContext,
                                    subscriberRegistry: SubscriberRegistry,
                                    propertiesMapper: PropertiesMapper,
                                    val eventBus: XLReleaseEventBus,
                                    val triggerRepository: TriggerRepository,
                                    val releaseRepository: ReleaseRepository)
  extends TriggerLifecycle[StatusWebhookTrigger]
    with Logging {

  override def supports(trigger: Trigger): Boolean = trigger.getType.instanceOf(Type.valueOf(classOf[StatusWebhookTrigger]))

  override def enable(trigger: StatusWebhookTrigger, checkReferencePermissions: Boolean): Unit = {
    disable(trigger)
    subscriberRegistry.subscribe(
      sourceId = trigger.endpoint.eventSource.getId,
      consumerConfig = new EventBasedTriggerConsumer(trigger)
    )
  }

  override def disable(trigger: StatusWebhookTrigger): Unit = {
    subscriberRegistry.remove(new EventBasedTriggerConsumer(trigger).consumerId)
  }

  override def execute(trigger: StatusWebhookTrigger, triggerExecutionContext: TriggerExecutionContext): TriggerExecutionResult[StatusWebhookTrigger] = {
    val result = runAction(trigger, triggerExecutionContext)
    TriggerExecutionResult(trigger, result)
  }

  override def getTriggerAction(trigger: StatusWebhookTrigger, triggerExecutionContext: TriggerExecutionContext): TriggerAction = {
    val action = trigger.instantiateAction()
    applicationContext.getAutowireCapableBeanFactory.autowireBean(action)
    action.init(trigger)
    triggerExecutionContext match {
      case EventBasedTriggerExecutionContext(event) =>
        propertiesMapper.mapProperties(trigger, event, action)
    }
    action.setTriggerId(trigger.getId)
    action
  }

  override def getOrder: Int = 11

}
