package com.xebialabs.xlrelease.triggers.event_based

import com.xebialabs.deployit.plugin.api.reflect.{DescriptorRegistry, Type}
import com.xebialabs.xlrelease.actors.initializer.SubscriptionInitializer
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters
import com.xebialabs.xlrelease.repository.TriggerRepository
import com.xebialabs.xlrelease.webhooks.registry.SubscriberRegistry
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class RestoreEventBasedTriggerSubscriberRegistry @Autowired()(val subscriberRegistry: SubscriberRegistry,
                                                              val triggerRepository: TriggerRepository) extends SubscriptionInitializer {

  final lazy val filterByEventBasedTriggers: TriggerFilters = {
    val filter: TriggerFilters = new TriggerFilters()
    filter.setTriggerType(List(Type.valueOf(classOf[EventBasedTrigger]).toString).asJava)
    filter
  }

  override def initialize(): Unit = {
    val types = Seq(Type.valueOf(classOf[EventBasedTrigger])) ++
      DescriptorRegistry.getSubtypes(Type.valueOf(classOf[EventBasedTrigger])).asScala
    for {
      trigger <- triggerRepository.findByType(types.toList, null).getContent.asScala
      if trigger.isEnabled
      eventBasedTrigger = trigger.asInstanceOf[EventBasedTrigger]
      if eventBasedTrigger.eventType != null
      consumerConfig = new EventBasedTriggerConsumer(eventBasedTrigger)
      if eventBasedTrigger.eventSource != null
    } {
      subscriberRegistry.subscribe(eventBasedTrigger.eventSource.sourceId, consumerConfig)
    }
  }

}
