package com.xebialabs.xlrelease.triggers.deployment_based

import com.xebialabs.deployit.plugin.api.reflect.{DescriptorRegistry, Type}
import com.xebialabs.xlrelease.actors.initializer.SubscriptionInitializer
import com.xebialabs.xlrelease.repository.TriggerRepository
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTriggerConsumer
import com.xebialabs.xlrelease.webhooks.registry.SubscriberRegistry
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters.CollectionHasAsScala

@Component
class RestoreStatusWebhookTriggerSubscriberRegistry (val subscriberRegistry: SubscriberRegistry,
                                                     val triggerRepository: TriggerRepository) extends SubscriptionInitializer {


  override def initialize(): Unit = {
    val types = Seq(Type.valueOf(classOf[StatusWebhookTrigger])) ++
      DescriptorRegistry.getSubtypes(Type.valueOf(classOf[StatusWebhookTrigger])).asScala
    for {
      trigger <- triggerRepository.findByType(types.toList, null).getContent.asScala
      if trigger.isEnabled
      statusWebhookTrigger = trigger.asInstanceOf[StatusWebhookTrigger]
      if statusWebhookTrigger.endpoint != null
      consumerConfig = new EventBasedTriggerConsumer(statusWebhookTrigger)
    } {
      subscriberRegistry.subscribe(statusWebhookTrigger.endpoint.eventSource.getId, consumerConfig)
    }
  }
}
