package com.xebialabs.xlrelease.udm.reporting.filters

import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.udm.reporting.filters.impl._
import com.xebialabs.xlrelease.udm.reporting.repository.sql.DeploymentsSqlBuilder

class DeploymentsSqlBuilderVisitor(override val builder: DeploymentsSqlBuilder)
  extends ArchiveSqlFilterVisitor[DeploymentsSqlBuilder](builder) {


  override def wrap(builder: DeploymentsSqlBuilder): DeploymentsSqlBuilderVisitor = new DeploymentsSqlBuilderVisitor(builder)


  override def visit(filter: ApplicationFilter): Unit = {
    builder.withApplicationId(Ids.getName(filter.getApplicationId))
  }

  override def visit(filter: EnvironmentFilter): Unit = {
    builder.withEnvironmentId(Ids.getName(filter.getEnvironmentId))
  }

  override def visit(filter: EnvironmentLabelFilter): Unit = {
    //special case do nothing
  }

  override def visit(filter: EnvironmentStageFilter): Unit = {
    //todo do nothing as a special case
  }

  override def visit(filter: ReleaseFilter): Unit = {
    throw new IllegalStateException("not possible")
  }

  override def visit(filter: ReleaseStatusFilter): Unit = {
    throw new IllegalStateException("not possible")
  }
}
