package com.xebialabs.xlrelease.udm.reporting.filters;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import java.util.Objects;

@Metadata(label = "EnvironmentLabelFilter", versioned = false)
public class EnvironmentLabelFilter extends SimpleFilter {
    @Property(description = "The ID of the environment label to filter.")
    private String environmentLabelId = "";

    public EnvironmentLabelFilter() {
    }

    public EnvironmentLabelFilter(String environmentLabelId) {
        this.environmentLabelId = environmentLabelId;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final EnvironmentLabelFilter that = (EnvironmentLabelFilter) o;
        return Objects.equals(environmentLabelId, that.environmentLabelId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), environmentLabelId);
    }

    @Override
    public String toString() {
        return "EnvironmentLabelFilter[environmentLabelId = " + environmentLabelId + "]";
    }

    public String getEnvironmentLabelId() {
        return environmentLabelId;
    }

    public void setEnvironmentLabelId(final String environmentLabelId) {
        this.environmentLabelId = environmentLabelId;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }

}
