package com.xebialabs.xlrelease.udm.reporting.filters

import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile
import com.xebialabs.xlrelease.reports.filters.{ReportFilter, CompositeFilter => RCompositeFilter}

import java.util
import scala.jdk.CollectionConverters._

object TileFilters {
  val FILTERS_PROPERTY = "filters"

  def getFilterTypes(tile: Tile): util.List[String] = getFilterTypes(getFilters(tile))

  def getFilterTypes(filters: util.List[ReportFilter]): util.List[String] =
    Option(filters).map(_.asScala.flatMap(getFilterTypes(_).asScala)).getOrElse(Seq.empty).distinct.asJava

  def getFilterTypes(filter: ReportFilter): util.List[String] = (filter match {
    case composite: RCompositeFilter => getFilterTypes(composite.getFilters).asScala
    case filter => Seq(filter.getType.toString)
  }).distinct.asJava

  def addFilterIfMissing(tile: Tile, filter: ReportFilter): Tile = {
    val filters = getFilters(tile)
    if (!getFilterTypes(filters).containsAll(getFilterTypes(filter))) {
      filters.add(filter)
    }
    tile.setProperty(FILTERS_PROPERTY, filters)
    tile
  }

  def getFilters(tile: Tile): util.List[ReportFilter] = if (tile.hasProperty(FILTERS_PROPERTY)) {
    Option(tile.getProperty[util.List[ReportFilter]](FILTERS_PROPERTY)).getOrElse(new util.ArrayList[ReportFilter]())
  } else {
    new util.ArrayList[ReportFilter]()
  }

}
