package com.xebialabs.xlrelease.udm.reporting.filters.impl;

import java.util.Objects;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.udm.reporting.filters.SimpleFilter;
import com.xebialabs.xlrelease.udm.reporting.filters.UdmReportFilterVisitor;

@Metadata(label = "ReleaseStatusFilter", versioned = false)
public class ReleaseStatusFilter extends SimpleFilter {

    @Property(description = "The status of the release to filter.")
    private ReleaseStatus status;

    public ReleaseStatusFilter() {
    }

    public ReleaseStatusFilter(ReleaseStatus status) {
        this.status = status;
    }

    public ReleaseStatus getReleaseStatus() {
        return status;
    }

    public void setReleaseStatus(ReleaseStatus status) {
        this.status = status;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final ReleaseStatusFilter that = (ReleaseStatusFilter) o;
        return this.status == that.status;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), status);
    }

    @Override
    public String toString() {
        return "ReleaseStatusFilter[status = " + status + "]";
    }
}
