package com.xebialabs.xlrelease.webhooks.registry

import akka.actor.ActorRef
import com.xebialabs.xlplatform.cluster.ClusterMode.FULL
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.actors.initializer.ActorInitializer
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.Profile
import org.springframework.stereotype.Component

@Component
@Profile(Array(FULL))
class SubscriberRegistryActorInitializer @Autowired()(xlrConfig: XlrConfig,
                                                      val subscriberRegistry: ClusterSubscriberRegistryService,
                                                      subscriberRegistryActorHolder: SubscriberRegistryActorHolder,
                                                      systemHolder: ActorSystemHolder,
                                                      val configurationRepository: ConfigurationRepository)
  extends ActorInitializer with Logging {

  lazy val subscriberRegistryActor: ActorRef = {
    systemHolder.actorSystem.actorOf(
      SubscriberRegistryActor.props(subscriberRegistry)
    )
  }

  override def initialize(): Unit = {
    logger.debug("Initializing SubscriberRegistryActor...")
    subscriberRegistryActorHolder.resolveActorRef(subscriberRegistryActor)
    subscriberRegistryActor
  }
}

