package com.xebialabs.xlrelease.webhooks.endpoint

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlplatform.webhooks.domain.Endpoint
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.webhooks.authentication.BaseRequestAuthentication


@Metadata(
  label = "HTTP Endpoint for Webhooks with Authentication",
  virtual = true)
abstract class AuthenticationWebhookEndpoint extends BaseSource with Endpoint {
  override type RequestAuthenticationType = BaseRequestAuthentication

  override def setId(id: String): Unit = {
    super.setId(id)
    if (authentication != null) {
      authentication.setId(id + Ids.SEPARATOR + BaseRequestAuthentication.AUTHENTICATION_ID_SUFFIX)
    }
  }
}
