package com.xebialabs.xlrelease.webhooks

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.webhooks.domain.HttpRequestEvent
import com.xebialabs.xlrelease.webhooks.endpoint.WebhookEndpoint

import scala.jdk.CollectionConverters._

package object task {
  val REACTIVE_TASK_TYPE = Type.valueOf("webhook.ReactiveTask")
  val EVENT_TYPE = Type.valueOf(classOf[HttpRequestEvent])
  val ENDPOINT_TYPE = Type.valueOf(classOf[WebhookEndpoint])
  val ENDPOINT_PROPERTY = "endpoint"

  val SCRIPT_PROPERTY = "condition"
  val SCRIPT_LOCATION_PROPERTY = "webhookScriptLocation"
  val EVENT_PROPERTY = "event"

  def isImplicitReactive(taskType: Type): Boolean = {
    taskType.getDescriptor.getPropertyDescriptors.asScala.exists(_.getReferencedType == ENDPOINT_TYPE)
  }
}
