package com.xebialabs.xlrelease.webhooks.consumers.jython

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.webhooks.consumers.BaseProcessor

import scala.beans.BeanProperty


@Metadata(virtual = true, label="Scripted event source (Jython)")
class JythonScriptEventSource() extends BaseProcessor {

  @BeanProperty
  @Property(
    category = "input",
    size = Property.Size.LARGE,
    required = false,
    defaultValue = "accepted = True",
    label = "Filter script",
    description = "Script that decides if an incoming event should be consumed or not.\nThe script should set the 'accepted' variable to either True or False.\nThe input event is accessible through the 'input' variable."
  )
  var filterScript: String = _

  @BeanProperty
  @Property(
    category = "input",
    size = Property.Size.LARGE,
    defaultValue = "output = input",
    label = "Map script",
    description = "Script that maps the input event to an output event.\nThe script should set the 'output' variable to an Event instance whose type is compatible with this event source's outputEventType.\nThe input event is accessible through the 'input' variable."
  )
  var mapScript: String = _

}
