package com.xebialabs.xlplatform.webhooks.events.domain

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.Property
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.xlplatform.webhooks.annotations.TypeBounds
import com.xebialabs.xlplatform.webhooks.events.domain.EventSource.CiEventSource

import scala.beans.BeanProperty

trait EventConsumer {
  self: BaseConfigurationItem =>

  def consumerId: EventConsumer.ID = self.getId

  @BeanProperty
  @Property(label = "Event source", description = "Event source")
  var eventSource: CiEventSource = _

  @TypeBounds(focusType = "events.Event", focusProperty = "eventSource.outputEventType", topType = "events.Event")
  @BeanProperty
  @Property(label = "Input Event Type", description = "Type of the input event")
  var inputEventType: String = _

  def inputType: Type = Option(inputEventType).orElse(Option(eventSource).map(_.outputEventType)).map(Type.valueOf).orNull

  @BeanProperty
  @Property(label = "Enabled", description = "Enable this event consumer")
  var consumerEnabled: Boolean = true

}

object EventConsumer {
  type ID = String

  type CiEventConsumer = BaseConfigurationItem with EventConsumer

}
