package com.xebialabs.xlplatform.webhooks.queue

import com.xebialabs.xlplatform.webhooks.events.domain.{Event, EventSource}
import com.xebialabs.xlplatform.webhooks.events.handlers.EventSourceHandler
import grizzled.slf4j.Logging
import org.springframework.jms.core.JmsTemplate

// EventSource that publishes the incoming events to a JMS Queue
trait JmsEventPublisherHandler[E <: Event, S <: EventSource]
  extends EventSourceHandler[E, S]
    with Logging {

  def jmsTemplate: JmsTemplate
  def queueName: String

  override def publishEvent(config: S, event: E): Boolean = {
    logger.debug(s"publishEvent($config, $event)")
    jmsTemplate.convertAndSend(queueName, event)
    true
  }
}

