package com.xebialabs.xlrelease.webhooks.consumers.logging

import com.xebialabs.xlrelease.domain.events.XLReleaseEvent

/**
  * Common interface for domain events related to webhooks.
  */
sealed trait WebHookEvent extends XLReleaseEvent

/**
  * Common interface for domain events related to webhook requests.
  */
sealed trait WebHookRequestEvent extends WebHookEvent

/**
  * Event published when a webhook request is accepted.
  *
  * @param path of the webhook.
  */
case class WebHookRequestAcceptedEvent(path: String) extends WebHookRequestEvent

/**
  * Event published when a webhook request is rejected.
  *
  * @param exceptionMessage of the event.
  */
case class WebHookRequestIgnoredEvent(exceptionMessage: String) extends WebHookRequestEvent

/**
  * Event published when a webhook request is unauthorized.
  *
  * @param exceptionMessage of the event.
  */
case class WebHookRequestUnauthorizedEvent(exceptionMessage: String) extends WebHookRequestEvent

/**
  * XLReleaseEvent published when the JmsDispatcher dispatches a xebialabs.Event.
  *
  * @param sourceId  of the source.
  * @param eventType the xebialabs.Event.
  */
case class JmsDispatcherEvent(sourceId: String, eventType: String) extends XLReleaseEvent