package com.xebialabs.xlrelease.webhooks.registry

import com.xebialabs.xlplatform.cluster.ClusterMode.FULL
import com.xebialabs.xlplatform.webhooks.events.domain.EventConsumer.CiEventConsumer
import com.xebialabs.xlplatform.webhooks.events.domain.{EventConsumer, EventSource}
import com.xebialabs.xlrelease.webhooks.registry.SubscriberRegistryActor.{Broadcast, RemoveConsumer, SubscribeConsumer, UnsubscribeConsumer}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.Profile
import org.springframework.stereotype.Component


@Component
@Profile(Array(FULL))
class ClusterSubscriberRegistryService @Autowired()(subscriberRegistryActorHolder: SubscriberRegistryActorHolder) extends SubscriberRegistry {

  def remoteSubscribe: (EventSource.ID, CiEventConsumer) => Unit = super.subscribe

  def remoteUnsubscribe: (EventSource.ID, EventConsumer.ID) => Unit = super.unsubscribe

  def remoteRemove: EventConsumer.ID => Unit = super.remove

  override def subscribe(sourceId: EventSource.ID, consumer: CiEventConsumer): Unit = {
    super.subscribe(sourceId, consumer)
    subscriberRegistryActorHolder.actorRef() ! Broadcast(SubscribeConsumer(sourceId, consumer))
  }

  override def unsubscribe(sourceId: EventSource.ID, consumerId: EventConsumer.ID): Unit = {
    super.unsubscribe(sourceId, consumerId)
    subscriberRegistryActorHolder.actorRef() ! Broadcast(UnsubscribeConsumer(sourceId, consumerId))
  }

  override def remove(consumerId: EventConsumer.ID): Unit = {
    super.remove(consumerId)
    subscriberRegistryActorHolder.actorRef() ! Broadcast(RemoveConsumer(consumerId))
  }

}
