# --- copy pasted from globals.py, only vars_wrapper is modified ---
import inspect
import re

from org.springframework.security.core.context import SecurityContextHolder
from java.lang import RuntimeException, UnsupportedOperationException
from com.xebialabs.xlrelease.utils import DateVariableUtils

# Those imports make API objects available in all user scripts so they don't have to
# import classes by themselves
from com.xebialabs.xlrelease.api.v1.forms import Comment
from com.xebialabs.xlrelease.api.v1.forms import Condition
from com.xebialabs.xlrelease.api.v1.forms import CreateRelease
from com.xebialabs.xlrelease.api.v1.forms import StartRelease
from com.xebialabs.xlrelease.api.v1.forms import StartTask
from com.xebialabs.xlrelease.api.v1.forms import UserAccount
from com.xebialabs.xlrelease.api.v1.forms import Variable

def run_as_wrapper(attribute):
    def wrapped_function(*args):
        if SecurityContextHolder.getContext().getAuthentication() is None:
            raise RuntimeException("A 'Run automated tasks as user' and 'Password' properties has to be set in order to use XL Release's API")
        return attribute(*args)

    return wrapped_function

def run_as_wrapper_without_permissions_check(attribute):
    def wrapped_function(*args):
        return attribute(*args)

    return wrapped_function


def vars_wrapper(attribute):
    def wrapped_function(*args):
        try:
            return attribute(*args)
        except UnsupportedOperationException:
            raise UnsupportedOperationException("You cannot modify variables in Reactive Task condition")

    return wrapped_function

def dateTime(dateStr):
    return DateVariableUtils.parseDate(dateStr)

class SugarifiedResource:
    def __init__(self, resource, pointcut=inspect.isfunction, wrapper=run_as_wrapper):
        self.resource = resource
        self.pointcut = pointcut
        self.wrapper = wrapper

    def __getattr__(self, name):
        wrapped_attribute = wrap(getattr(self.resource, name))
        if self.pointcut(wrapped_attribute):
            return self.wrapper(wrapped_attribute)
        return wrapped_attribute


for k in globals().keys():
    if (re.match("_(.*)Api", k)):
        v = globals()[k]
        if k != "_taskReportingApi":
            globals()[k[1:]] = SugarifiedResource(v)
        else:
            globals()[k[1:]] = SugarifiedResource(v, inspect.isfunction, run_as_wrapper_without_permissions_check)

if '_releaseVariables' in globals():
    releaseVariables = SugarifiedResource(_releaseVariables, lambda _: True, lambda attrib: vars_wrapper(attrib))
if '_globalVariables' in globals():
    globalVariables = SugarifiedResource(_globalVariables, lambda _: True, lambda attrib: vars_wrapper(attrib))
if '_folderVariables' in globals():
    folderVariables = SugarifiedResource(_folderVariables, lambda _: True, lambda attrib: vars_wrapper(attrib))

if '_valueProvider' in globals():
    valueProvider = wrap(_valueProvider)
# -- end copy paste ---

if 'headers' not in globals():
    headers = {}
if 'parameters' not in globals():
    parameters = {}

event = Map(event)
headers = Map(headers)
parameters = Map(parameters)
