package com.xebialabs.xlrelease.webhooks.cleanup

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.quartz.release.scheduler.{QuartzScheduledService, ReleaseSchedulerService}
import com.xebialabs.xlrelease.utils.QuartzUtils._
import com.xebialabs.xlrelease.webhooks.cleanup.EventRecordCleanupService.{CLEANUP_SERVICE_NAME, GROUP_NAME, JOB_NAME}
import org.quartz.CronScheduleBuilder.cronSchedule
import org.quartz.JobBuilder.newJob
import org.quartz.TriggerBuilder.newTrigger
import org.quartz.{CronTrigger, JobDetail, Trigger}
import org.springframework.stereotype.Service

import java.util.Date

@Service
class EventRecordCleanupService(val releaseSchedulerService: ReleaseSchedulerService,
                                xlrConfig: XlrConfig) extends QuartzScheduledService {

  private val delay: Long = xlrConfig.durations.startupJobsDelay.toMillis

  private lazy val job: JobDetail = newJob(classOf[EventRecordCleanupQuartzJob])
    .withDescription(s"$CLEANUP_SERVICE_NAME job")
    .withIdentity(JOB_NAME, GROUP_NAME)
    .storeDurably(true)
    .build()

  private lazy val trigger: CronTrigger = newTrigger()
    .withIdentity(JOB_NAME, GROUP_NAME)
    .withDescription(s"Trigger $CLEANUP_SERVICE_NAME jobs")
    .withSchedule(
      cronSchedule(xlrConfig.features.webhooks.retentionPolicy.schedule.asQuartzCron)
        .withMisfireHandlingInstructionDoNothing()
    )
    .startAt(Date.from(new Date().toInstant.plusMillis(delay)))
    .build()

  override def getJobDetail: JobDetail = job

  override def getTrigger: Trigger = trigger

  override def serviceName(): String = CLEANUP_SERVICE_NAME
}

object EventRecordCleanupService {
  val CLEANUP_SERVICE_NAME = "Event Record Cleanup"
  val JOB_NAME = "EVENT_RECORD_CLEANUP_JOB"
  val GROUP_NAME = "CLEANUP"
}

