package com.xebialabs.xlrelease.webhooks.configuration.jms

import com.xebialabs.xlplatform.webhooks.events.domain.Event
import com.xebialabs.xlplatform.webhooks.events.domain.Event.{decode, encode}
import grizzled.slf4j.Logging
import org.springframework.jms.support.converter.MessageConverter

import jakarta.jms.{Message, Session, TextMessage}


object EventMessageConverter extends MessageConverter with Logging {

  def toMessage(instance: Any, session: Session): Message = {
    val event = instance.asInstanceOf[Event]
    logger.trace(s"e2m: ${event.received}@${event.sourceId}: ${event.getType}")
    val message = session.createTextMessage()
    message.setText(encode(event))
    logger.trace(s"e2m: => ${message.getText}")
    message
  }

  def fromMessage(message: Message): AnyRef = {
    logger.trace(s"fromMessage: ${message}")
    val content = message.asInstanceOf[TextMessage].getText
    logger.trace(s"m2e: $content")
    val event = decode(content)
    logger.trace(s"m2e: => ${event.received}@${event.sourceId}: ${event.getType}")
    event
  }

}
