package com.xebialabs.xlrelease.webhooks.dispatcher

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.webhooks.events.domain.{Event, EventConsumer, EventSource}
import com.xebialabs.xlplatform.webhooks.events.handlers.EventDispatcherHandler
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.service.CiIdService
import com.xebialabs.xlrelease.webhooks.consumers.BaseConsumerHandler
import com.xebialabs.xlrelease.webhooks.registry.SubscriberRegistry
import com.xebialabs.xlrelease.webhooks.repository.persistence.CiEventRecordsPersistence
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.collection.mutable
import scala.jdk.CollectionConverters._

@Component
class JmsDispatcherHandler @Autowired()(val config: JmsDispatcher,
                                        subscriberRegistry: SubscriberRegistry,
                                        ciIdService: CiIdService,
                                        ciEventRecordsPersistence: CiEventRecordsPersistence,
                                        handlers: java.util.List[BaseConsumerHandler[_]])
  extends JmsEventListenerHandler[Event, JmsDispatcher]
    with EventDispatcherHandler[Event, Event, EventConsumer, BaseConsumerHandler[EventConsumer]] {

  def consumeEvent(config: JmsDispatcher, event: Event): Boolean = {
    event.setId(Ids.getName(ciIdService.getUniqueId(Type.valueOf(classOf[Event]), "")))
    ciEventRecordsPersistence.insert(event)

    dispatch(event)
    true
  }

  lazy val handlersScala: mutable.Buffer[BaseConsumerHandler[_ <: EventConsumer]] =
    handlers.asScala.map(_.asInstanceOf[BaseConsumerHandler[EventConsumer]])

  def consumers: EventSource.ID => Map[EventConsumer, _ <: BaseConsumerHandler[EventConsumer]] = {
    sourceId => {
      logger.info(s"lookup up consumers for $sourceId")
      for {
        consumerConfig <- subscriberRegistry.list(sourceId)
        consumer <- handlersScala.find(c => consumerConfig.getType.instanceOf(c.consumerConfigType)).orElse {
          logger.warn(s"no idea what to do with consumerConfig '$consumerConfig' of type '${consumerConfig.getType}'")
          None
        }
      } yield consumerConfig -> consumer.asInstanceOf[BaseConsumerHandler[EventConsumer]]
    }.toMap
  }

}
