package com.xebialabs.xlrelease.webhooks.cleanup

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence
import com.xebialabs.xlrelease.webhooks.cleanup.EventRecordCleanupQuartzJob.REQUEST_RETENTION
import com.xebialabs.xlrelease.webhooks.consumers.BaseConsumer
import com.xebialabs.xlrelease.webhooks.endpoint.BaseSource
import com.xebialabs.xlrelease.webhooks.repository.persistence.CiEventRecordsPersistence
import grizzled.slf4j.Logging
import org.quartz.{DisallowConcurrentExecution, Job, JobExecutionContext}
import org.springframework.beans.factory.annotation.Autowired

import scala.jdk.CollectionConverters._
import scala.util.{Failure, Success, Try}

object EventRecordCleanupQuartzJob {
  val REQUEST_RETENTION = "requestRetention"
}

@DisallowConcurrentExecution
class EventRecordCleanupQuartzJob extends Job with Logging {

  @Autowired
  var eventRecordsPersistence: CiEventRecordsPersistence = _

  @Autowired
  var configurationRepository: ConfigurationRepository = _

  @Autowired
  var configurationPersistence: ConfigurationPersistence = _

  override def execute(context: JobExecutionContext): Unit = {
    logger.debug("Executing webhook request cleanup job")
    Try {
      for {
        configuration <- findConfigurations()
        configUid = configuration.getCiUid
        requestsToRetain = Try(configuration.getProperty[Int](REQUEST_RETENTION)).getOrElse(100)
      } yield eventRecordsPersistence.deleteRecordsByUuid(configUid, requestsToRetain)
    } match {
      case Failure(ex) => logger.error(s"Webhook request cleanup aborted due to an exception", ex)
      case Success(_) => logger.info(s"Webhook request cleanup finished")
    }
  }

  private def findConfigurations(): List[_ <: BaseConfiguration] = {
    configurationRepository.findAllByType[BaseSource](Type.valueOf(classOf[BaseSource])).asScala.toList ++
    configurationRepository.findAllByType[BaseConsumer](Type.valueOf(classOf[BaseConsumer])).asScala.toList
  }
}
