package com.xebialabs.xlrelease.webhooks.endpoint

import com.xebialabs.xlplatform.webhooks.authentication.RequestAuthenticationMethod
import com.xebialabs.xlplatform.webhooks.endpoint.EndpointProvider
import com.xebialabs.xlplatform.webhooks.events.handlers.EventPublisher
import com.xebialabs.xlrelease.events.EventBus
import com.xebialabs.xlrelease.service.ConfigurationVariableService
import org.springframework.stereotype.Controller

import jakarta.servlet.http.HttpServletRequest
import jakarta.ws.rs._
import jakarta.ws.rs.core.{Context, MediaType, Response}

@Path("/webhooks")
@Produces(Array(MediaType.APPLICATION_JSON))
@Consumes(Array(MediaType.APPLICATION_JSON))
@Controller
class WebhooksResource(endpointProvider: EndpointProvider,
                       configurationVariableService: ConfigurationVariableService,
                       eventBus: EventBus,
                       val eventPublisher: EventPublisher,
                       // we need to autowire this here to make sure, that Jython
                       // scripting components are ready by the time we receive
                       // first call
                       authenticationMethods: java.util.List[RequestAuthenticationMethod])
  extends WebhooksEndpointEventSourceHandler(ResolvingEndpointProvider(endpointProvider, configurationVariableService), eventBus) {

  @GET
  @Path("{endpointPath}")
  def acceptGET(@PathParam("endpointPath") path: String,
                @Context request: HttpServletRequest): Response = {
    accept(path, request)
  }

  @POST
  @Path("{endpointPath}")
  def acceptPOST(@PathParam("endpointPath") path: String,
                 @Context request: HttpServletRequest): Response = {
    accept(path, request)
  }

}
