/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.webhooks.endpoint;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlplatform.cluster.NodeState$;
import com.xebialabs.xlplatform.webhooks.authentication.RequestAuthenticationMethod;
import com.xebialabs.xlplatform.webhooks.domain.Endpoint;
import com.xebialabs.xlplatform.webhooks.domain.HttpRequestEvent;
import com.xebialabs.xlplatform.webhooks.domain.HttpRequestEvent$;
import com.xebialabs.xlplatform.webhooks.domain.RequestAuthentication;
import com.xebialabs.xlplatform.webhooks.endpoint.EndpointProvider;
import com.xebialabs.xlplatform.webhooks.events.domain.Event;
import com.xebialabs.xlplatform.webhooks.events.domain.EventSource;
import com.xebialabs.xlplatform.webhooks.events.handlers.EventSourceHandler;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.webhooks.consumers.logging.WebHookRequestAcceptedEvent;
import com.xebialabs.xlrelease.webhooks.consumers.logging.WebHookRequestIgnoredEvent;
import com.xebialabs.xlrelease.webhooks.consumers.logging.WebHookRequestUnauthorizedEvent;
import com.xebialabs.xlrelease.webhooks.endpoint.exceptions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import java.io.Reader;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de!\u0002\b\u0010\u0003\u0003Q\u0002\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\r\u0003!\u0011!Q\u0001\n\u0011CQ!\u0013\u0001\u0005\u0002)CQa\u0014\u0001\u0005\u0002ACQ\u0001\u001e\u0001\u0005\nUDQA \u0001\u0005\n}Dq!!\u0007\u0001\t\u0013\tY\u0002C\u0004\u0002(\u0001!I!!\u000b\t\u000f\u0005=\u0002\u0001\"\u0003\u00022!9\u0011q\u0007\u0001\u0005\n\u0005e\u0002bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003W\u0002A\u0011BA7\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003\u0013!eV3cQ>|7n]#oIB|\u0017N\u001c;Fm\u0016tGoU8ve\u000e,\u0007*\u00198eY\u0016\u0014(B\u0001\t\u0012\u0003!)g\u000e\u001a9pS:$(B\u0001\n\u0014\u0003!9XM\u00195p_.\u001c(B\u0001\u000b\u0016\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0017/\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00021\u0005\u00191m\\7\u0004\u0001M!\u0001aG\u00116!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fMB!!E\u000b\u00173\u001b\u0005\u0019#B\u0001\u0013&\u0003!A\u0017M\u001c3mKJ\u001c(B\u0001\u0014(\u0003\u0019)g/\u001a8ug*\u0011!\u0003\u000b\u0006\u0003SU\t!\u0002\u001f7qY\u0006$hm\u001c:n\u0013\tY3E\u0001\nFm\u0016tGoU8ve\u000e,\u0007*\u00198eY\u0016\u0014\bCA\u00171\u001b\u0005q#BA\u0018(\u0003\u0019!w.\\1j]&\u0011\u0011G\f\u0002\u0011\u0011R$\bOU3rk\u0016\u001cH/\u0012<f]R\u0004\"!L\u001a\n\u0005Qr#\u0001C#oIB|\u0017N\u001c;\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014!B:mMRR'\"\u0001\u001e\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!\u0001P\u001c\u0003\u000f1{wmZ5oO\u0006\u0001RM\u001c3q_&tG\u000f\u0015:pm&$WM\u001d\t\u0003\u007f\u0005k\u0011\u0001\u0011\u0006\u0003!\u001dJ!A\u0011!\u0003!\u0015sG\r]8j]R\u0004&o\u001c<jI\u0016\u0014\u0018\u0001C3wK:$()^:\u0011\u0005\u0015;U\"\u0001$\u000b\u0005\u0019\u001a\u0012B\u0001%G\u0005!)e/\u001a8u\u0005V\u001c\u0018A\u0002\u001fj]&$h\bF\u0002L\u001b:\u0003\"\u0001\u0014\u0001\u000e\u0003=AQ!P\u0002A\u0002yBQaQ\u0002A\u0002\u0011\u000ba!Y2dKB$HcA)^UB\u0011!kW\u0007\u0002'*\u0011A+V\u0001\u0005G>\u0014XM\u0003\u0002W/\u0006\u0011!o\u001d\u0006\u00031f\u000b!a^:\u000b\u0003i\u000bqA[1lCJ$\u0018-\u0003\u0002]'\nA!+Z:q_:\u001cX\rC\u0003_\t\u0001\u0007q,\u0001\u0003qCRD\u0007C\u00011h\u001d\t\tW\r\u0005\u0002c;5\t1M\u0003\u0002e3\u00051AH]8pizJ!AZ\u000f\u0002\rA\u0013X\rZ3g\u0013\tA\u0017N\u0001\u0004TiJLgn\u001a\u0006\u0003MvAQa\u001b\u0003A\u00021\fqA]3rk\u0016\u001cH\u000f\u0005\u0002ne6\taN\u0003\u0002pa\u0006!\u0001\u000e\u001e;q\u0015\t\t\u0018,A\u0004tKJ4H.\u001a;\n\u0005Mt'A\u0005%uiB\u001cVM\u001d<mKR\u0014V-];fgR\fa\u0002\u001d:pG\u0016\u001c8OU3rk\u0016\u001cH\u000fF\u0002wyv\u00042a\u001e>R\u001b\u0005A(BA=\u001e\u0003\u0011)H/\u001b7\n\u0005mD(a\u0001+ss\")a,\u0002a\u0001?\")1.\u0002a\u0001Y\u0006Y\u0001.\u00198eY\u0016,%O]8s+\t\t\t\u0001\u0005\u0004\u001d\u0003\u0007\t9!U\u0005\u0004\u0003\u000bi\"a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\u0011\t\u0005%\u00111\u0003\b\u0005\u0003\u0017\tyAD\u0002c\u0003\u001bI\u0011AH\u0005\u0004\u0003#i\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003+\t9BA\u0005UQJ|w/\u00192mK*\u0019\u0011\u0011C\u000f\u0002\u0019\rDWmY6F]\u0006\u0014G.\u001a3\u0015\t\u0005u\u0011Q\u0005\t\u0005oj\fy\u0002E\u0002\u001d\u0003CI1!a\t\u001e\u0005\u0011)f.\u001b;\t\u000bA9\u0001\u0019\u0001\u001a\u0002\u0017\rDWmY6NKRDw\u000e\u001a\u000b\u0007\u0003;\tY#!\f\t\u000b-D\u0001\u0019\u00017\t\u000bAA\u0001\u0019\u0001\u001a\u0002\u0017\u001d,G/\u00128ea>Lg\u000e\u001e\u000b\u0005\u0003g\t)\u0004E\u0002xuJBQAX\u0005A\u0002}\u000badZ3u%\u0016\fX/Z:u\u0003V$\b.\u001a8uS\u000e\fG/[8o\u001b\u0016$\bn\u001c3\u0015\t\u0005m\u0012\u0011\n\t\u0005oj\fi\u0004\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019eJ\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0013\u0011\t9%!\u0011\u00037I+\u0017/^3ti\u0006+H\u000f[3oi&\u001c\u0017\r^5p]6+G\u000f[8e\u0011\u0015\u0001\"\u00021\u00013\u0003M\tW\u000f\u001e5f]RL7-\u0019;f%\u0016\fX/Z:u))\ti\"a\u0014\u0002R\u0005m\u0013q\r\u0005\u0006!-\u0001\rA\r\u0005\b\u0003'Z\u0001\u0019AA+\u0003\u001dAW-\u00193feN\u0004R\u0001YA,?~K1!!\u0017j\u0005\ri\u0015\r\u001d\u0005\b\u0003;Z\u0001\u0019AA0\u0003\u0019\u0001\u0018M]1ngB1\u0001-a\u0016`\u0003C\u0002B\u0001HA2?&\u0019\u0011QM\u000f\u0003\u000b\u0005\u0013(/Y=\t\r\u0005%4\u00021\u0001`\u0003\u001d\u0001\u0018-\u001f7pC\u0012\fQB]3rk\u0016\u001cH\u000f\u0015:fM&DH\u0003BA8\u0003{\u0002B!!\u001d\u0002|5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(\u0001\u0003mC:<'BAA=\u0003\u0011Q\u0017M^1\n\u0007!\f\u0019\bC\u0003l\u0019\u0001\u0007A.\u0001\nqk\nd\u0017n\u001d5FeJ|'/\u0012<f]R\u001cH\u0003BA\u0010\u0003\u0007Cq!!\"\u000e\u0001\u0004\t9!\u0001\u0002fq\u0002")
public abstract class WebhooksEndpointEventSourceHandler
implements EventSourceHandler<HttpRequestEvent, Endpoint>,
Logging {
    private final EndpointProvider endpointProvider;
    private final EventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public boolean publish(EventSource config, Event event) {
        return EventSourceHandler.publish$(this, config, event);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WebhooksEndpointEventSourceHandler webhooksEndpointEventSourceHandler = this;
        synchronized (webhooksEndpointEventSourceHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Response accept(String path, HttpServletRequest request) {
        if (NodeState$.MODULE$.isActive()) {
            return (Response)this.processRequest(path, request).recover(this.handleError()).get();
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Node is not active").build();
    }

    private Try<Response> processRequest(String path, HttpServletRequest request) {
        Try result = this.getEndpoint(path).flatMap((Function1 & Serializable)endpoint -> this.checkEnabled((Endpoint)endpoint).flatMap((Function1 & Serializable)x$6 -> {
            BoxedUnit boxedUnit = x$6;
            return this.checkMethod(request, (Endpoint)endpoint).flatMap((Function1 & Serializable)x$5 -> {
                BoxedUnit boxedUnit = x$5;
                return Try$.MODULE$.apply((Function0 & Serializable)() -> IOUtils.toString((Reader)request.getReader())).map((Function1 & Serializable)payload -> {
                    scala.collection.immutable.Map reqHeaders = WebhooksEndpointEventSourceHandler.getHeaders$1(request);
                    scala.collection.immutable.Map reqParams = WebhooksEndpointEventSourceHandler.getParams$1(request);
                    return new Tuple3(payload, (Object)reqHeaders, (Object)reqParams);
                }).flatMap((Function1 & Serializable)x$4 -> {
                    Tuple3 tuple3 = x$4;
                    if (tuple3 != null) {
                        String payload = (String)tuple3._1();
                        scala.collection.immutable.Map reqHeaders = (scala.collection.immutable.Map)tuple3._2();
                        scala.collection.immutable.Map reqParams = (scala.collection.immutable.Map)tuple3._3();
                        return this.authenticateRequest((Endpoint)endpoint, (scala.collection.immutable.Map<String, String>)reqHeaders, (scala.collection.immutable.Map<String, String[]>)reqParams, payload).map((Function1 & Serializable)x$1 -> {
                            HttpRequestEvent event = HttpRequestEvent$.MODULE$.apply((EventSource)endpoint, CollectionConverters$.MODULE$.MapHasAsJava((Map)reqHeaders).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)reqParams).asJava(), payload);
                            return new Tuple2(x$1, (Object)event);
                        }).flatMap((Function1 & Serializable)x$3 -> {
                            Tuple2 tuple2 = x$3;
                            if (tuple2 != null) {
                                HttpRequestEvent event = (HttpRequestEvent)((Object)((Object)((Object)((Object)((Object)((Object)tuple2._2()))))));
                                return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> this.publish((EventSource)endpoint, event)).map((Function1 & Serializable)published -> WebhooksEndpointEventSourceHandler.$anonfun$processRequest$11(BoxesRunTime.unboxToBoolean((Object)published))).map((Function1 & Serializable)x$2 -> {
                                    Tuple2 tuple2 = x$2;
                                    if (tuple2 != null) {
                                        Response.ResponseBuilder response = (Response.ResponseBuilder)tuple2._2();
                                        this.logger().trace((Function0 & Serializable)() -> this.requestPrefix(request) + ": Published event for " + endpoint);
                                        return response.build();
                                    }
                                    throw new MatchError((Object)tuple2);
                                });
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                    throw new MatchError((Object)tuple3);
                });
            });
        }));
        Try try_ = result;
        if (try_ instanceof Success) {
            this.eventBus.publish((XLReleaseEvent)new WebHookRequestAcceptedEvent("Accepted WebHook request for path: webhooks/" + path));
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            this.publishErrorEvents(ex);
        } else {
            throw new MatchError((Object)try_);
        }
        return result;
    }

    private PartialFunction<Throwable, Response> handleError() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ WebhooksEndpointEventSourceHandler $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof exceptions.WebhookEndpointControllerException) {
                    exceptions.WebhookEndpointControllerException webhookEndpointControllerException = (exceptions.WebhookEndpointControllerException)A1;
                    this.$outer.logger().warn((Function0 & Serializable)() -> webhookEndpointControllerException.getMessage(), (Function0 & Serializable)() -> {
                        if (webhookEndpointControllerException.logStackTrace()) {
                            return webhookEndpointControllerException;
                        }
                        return null;
                    });
                    return (B1)Response.status((Response.Status)webhookEndpointControllerException.status()).entity((Object)webhookEndpointControllerException.getMessage()).build();
                }
                if (A1 instanceof NotFoundException) {
                    NotFoundException notFoundException = (NotFoundException)A1;
                    this.$outer.logger().warn((Function0 & Serializable)() -> notFoundException.getMessage());
                    return (B1)Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)notFoundException.getMessage()).build();
                }
                if (A1 != null) {
                    A1 A12 = A1;
                    this.$outer.logger().warn((Function0 & Serializable)() -> A12.getMessage(), (Function0 & Serializable)() -> A12);
                    return (B1)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Exception happened when trying to process your request, check XLRelease log for details").build();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof exceptions.WebhookEndpointControllerException) {
                    return true;
                }
                if (throwable instanceof NotFoundException) {
                    return true;
                }
                return throwable != null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.webhooks.endpoint.exceptions$WebhookEndpointControllerException ), $anonfun$applyOrElse$2(com.xebialabs.xlrelease.webhooks.endpoint.exceptions$WebhookEndpointControllerException ), $anonfun$applyOrElse$3(com.xebialabs.deployit.exception.NotFoundException ), $anonfun$applyOrElse$4(java.lang.Throwable ), $anonfun$applyOrElse$5(java.lang.Throwable )}, serializedLambda);
            }
        };
    }

    private Try<BoxedUnit> checkEnabled(Endpoint endpoint) {
        if (NodeState$.MODULE$.isActive()) {
            if (!endpoint.sourceEnabled()) {
                return new Failure((Throwable)new exceptions.EndpointDisabled(endpoint));
            }
            return new Success((Object)BoxedUnit.UNIT);
        }
        return new Failure((Throwable)new exceptions.EndpointDisabled(endpoint));
    }

    private Try<BoxedUnit> checkMethod(HttpServletRequest request, Endpoint endpoint) {
        String string = endpoint.method().name();
        String string2 = request.getMethod();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return new Failure((Throwable)new exceptions.WrongMethod(request, endpoint));
        }
        return new Success((Object)BoxedUnit.UNIT);
    }

    private Try<Endpoint> getEndpoint(String path) {
        return this.endpointProvider.findEndpointByPath(path).recoverWith((PartialFunction)new Serializable(null, path){
            private static final long serialVersionUID = 0L;
            private final String path$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof NotFoundException) {
                    return (B1)new Failure((Throwable)new exceptions.EndpointNotFound(this.path$1));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof NotFoundException;
            }
            {
                this.path$1 = path$1;
            }
        });
    }

    private Try<RequestAuthenticationMethod> getRequestAuthenticationMethod(Endpoint endpoint) {
        Option authenticationMethod = Option$.MODULE$.apply((Object)endpoint.authentication()).flatMap((Function1 & Serializable)auth -> Option$.MODULE$.apply((Object)((RequestAuthentication)auth).requestAuthentication()).map((Function1 & Serializable)method -> method));
        return authenticationMethod.toRight((Function0 & Serializable)() -> new exceptions.EndpointAuthenticationMethodNotFound(endpoint)).toTry((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Try<BoxedUnit> authenticateRequest(Endpoint endpoint, scala.collection.immutable.Map<String, String> headers, scala.collection.immutable.Map<String, String[]> params, String payload) {
        return this.getRequestAuthenticationMethod(endpoint).flatMap((Function1 & Serializable)authenticationMethod -> {
            if (authenticationMethod.authenticateScala(endpoint, headers, params, payload)) {
                return new Success((Object)BoxedUnit.UNIT);
            }
            return new Failure((Throwable)new exceptions.UnauthorizedRequest(endpoint, (RequestAuthenticationMethod)authenticationMethod));
        });
    }

    private String requestPrefix(HttpServletRequest request) {
        return request.getRequestURI() + " from " + request.getRemoteAddr() + ":" + request.getRemotePort();
    }

    private void publishErrorEvents(Throwable ex) {
        Throwable throwable = ex;
        if (throwable instanceof exceptions.EndpointNotFound) {
            exceptions.EndpointNotFound endpointNotFound = (exceptions.EndpointNotFound)throwable;
            this.eventBus.publish((XLReleaseEvent)new WebHookRequestIgnoredEvent(endpointNotFound.getMessage()));
            return;
        }
        if (throwable instanceof exceptions.UnauthorizedRequest) {
            exceptions.UnauthorizedRequest unauthorizedRequest = (exceptions.UnauthorizedRequest)throwable;
            this.eventBus.publish((XLReleaseEvent)new WebHookRequestUnauthorizedEvent(unauthorizedRequest.getMessage()));
            return;
        }
        this.eventBus.publish((XLReleaseEvent)new WebHookRequestIgnoredEvent(ex.getMessage()));
    }

    private static final scala.collection.immutable.Map getHeaders$1(HttpServletRequest request$1) {
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(request$1.getHeaderNames()).asScala().map((Function1 & Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)request$1.getHeader(name))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final scala.collection.immutable.Map getParams$1(HttpServletRequest request$1) {
        return CollectionConverters$.MODULE$.MapHasAsScala(request$1.getParameterMap()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ Tuple2 $anonfun$processRequest$11(boolean published) {
        Response.ResponseBuilder response = published ? Response.ok() : Response.notAcceptable((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)published), (Object)response);
    }

    public WebhooksEndpointEventSourceHandler(EndpointProvider endpointProvider, EventBus eventBus) {
        this.endpointProvider = endpointProvider;
        this.eventBus = eventBus;
        EventSourceHandler.$init$(this);
        Logging.$init$((Logging)this);
    }
}

