package com.xebialabs.xlplatform.webhooks.events.handlers

import com.xebialabs.xlplatform.webhooks.events.domain.{Event, EventProcessor}
import grizzled.slf4j.Logging

import java.util.Date

/**
 * EventProcessorHandler is a trait that combines EventConsumerHandler and EventSourceHandler.
 * It is used to process events and publish the results.
 * When implementing EventProcessorHandler, only the filter and map methods need to be implemented.
 * @tparam IN The type of the input event
 * @tparam OUT The type of the output event
 * @tparam P The type of the EventProcessor
 */
trait EventProcessorHandler[IN <: Event, OUT <: Event, P <: EventProcessor]
  extends EventConsumerHandler[IN, P] with EventSourceHandler[OUT, P] {
  self: Logging =>

  override def filter(config: P, event: IN): Boolean = super.filter(config, event)

  def map(config: P, event: IN): OUT

  private def process(config: P, event: IN): Option[OUT] = {
    logger.debug(s"eventProc: process($config, $event)")
    Option(map(config, event)).map { output =>
      output.setSourceId(config.sourceId)
      output.received = new Date() // maybe
      output
    }
  }

  final override def consumeEvent(config: P, event: IN): Boolean = {
    logger.trace(s"eventProc: consumeEvent($config, $event)")
    process(config, event).exists(publish(config, _))
  }

}
