package com.xebialabs.xlrelease.webhooks.service.script

import com.xebialabs.xlrelease.script.XlrScriptContext
import com.xebialabs.xlrelease.webhooks.consumers.StatusWebhookEventSource

private class PatchScriptContextBuilder(connection: StatusWebhookEventSource) extends BaseScriptContextBuilder(connection) {

  override val scriptProperty: String = PatchScriptProperty

  override protected def doBuild(context: XlrScriptContext): Unit = {
    addConnectionServerAttributes(context)
    addConnectionAttributes(context)
    addScript(context)
  }
}

object PatchScriptContextBuilder {
  def createPatchScriptContext(connection: StatusWebhookEventSource): XlrScriptContext = {
    new PatchScriptContextBuilder(connection).build()
  }
}
