/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.spi.event.CiCopiedEvent;
import com.xebialabs.deployit.engine.spi.event.CiMovedEvent;
import com.xebialabs.deployit.engine.spi.event.CiRenamedEvent;
import com.xebialabs.deployit.engine.spi.event.CisCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.CisDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.CisUpdatedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.RuntimeRepositoryException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.JcrQueryTemplate;
import com.xebialabs.deployit.repository.NodeReader;
import com.xebialabs.deployit.repository.NodeReaderContext;
import com.xebialabs.deployit.repository.NodeUtils;
import com.xebialabs.deployit.repository.NodeWriter;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.SearchQueryBuilder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.deployit.util.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.value.ReferenceValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class JcrRepositoryService
implements RepositoryService {
    private final JcrTemplate jcrTemplate;
    private final PasswordEncrypter passwordEncrypter;
    private static Logger logger = LoggerFactory.getLogger(JcrRepositoryService.class);

    @Autowired
    public JcrRepositoryService(JcrTemplate jcrTemplate, PasswordEncrypter passwordEncrypter) {
        this.jcrTemplate = jcrTemplate;
        this.passwordEncrypter = passwordEncrypter;
    }

    @Override
    public boolean exists(final String id) {
        logger.debug("Checking whether node {} exists.", (Object)id);
        return this.jcrTemplate.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws RepositoryException {
                return session.itemExists(JcrPathHelper.getAbsolutePathFromId(id));
            }
        });
    }

    @Override
    public <T extends ConfigurationItem> T read(String id) {
        logger.debug("Reading node {}.", (Object)id);
        return this.read(id, null, true);
    }

    @Override
    public <T extends ConfigurationItem> T read(String id, WorkDir workDir) {
        logger.debug("Reading node {} with workdir {}.", (Object)id, (Object)workDir);
        return this.read(id, workDir, true);
    }

    @Override
    public <T extends ConfigurationItem> T read(String id, boolean useCache) {
        return this.read(id, null, useCache);
    }

    @Override
    public <T extends ConfigurationItem> T read(final String id, final WorkDir workDir, final boolean useCache) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        return (T)((ConfigurationItem)this.jcrTemplate.execute(new JcrCallback<T>(){

            @Override
            public T doInJcr(Session session) throws RepositoryException {
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(id));
                    if (useCache) {
                        return NodeReader.read(session, node, workDir, JcrRepositoryService.this.passwordEncrypter);
                    }
                    return NodeReader.read(session, node, workDir, new NodeReaderContext(), JcrRepositoryService.this.passwordEncrypter);
                }
                catch (PathNotFoundException exc) {
                    throw new NotFoundException("Repository entity [%s] not found", id);
                }
            }
        }));
    }

    @Override
    public <T extends ConfigurationItem> void create(T ... entities) {
        ChangeSet changeset = new ChangeSet();
        changeset.setCreateCis(Lists.newArrayList((Object[])entities));
        this.execute(changeset);
        EventBusHolder.publish(new CisCreatedEvent(entities));
    }

    @Override
    public <T extends ConfigurationItem> void move(String id, String newId) {
        ChangeSet changeSet = new ChangeSet();
        changeSet.addMoveCi(id, newId);
        this.execute(changeSet);
        EventBusHolder.publish(new CiMovedEvent(id, newId));
    }

    protected void checkMoveAllowed(Type type) {
    }

    protected void checkCopyAllowed(Session session, String toBeCopied, String newId) throws RepositoryException {
    }

    static Type readType(Session session, String id) throws RepositoryException {
        return Type.valueOf((String)session.getNode(JcrPathHelper.getAbsolutePathFromId(id)).getProperty("$configuration.item.type").getString());
    }

    static String extractParentId(String id) {
        int indexOf = id.lastIndexOf(47);
        if (indexOf != -1) {
            return id.substring(0, indexOf);
        }
        return id;
    }

    @Override
    public <T extends ConfigurationItem> void copy(String id, String newId) {
        ChangeSet changeSet = new ChangeSet();
        changeSet.addCopyCi(id, newId);
        this.execute(changeSet);
        EventBusHolder.publish(new CiCopiedEvent(id, newId));
    }

    @Override
    public void rename(String id, String newName) {
        Checks.checkArgument(newName.indexOf(47) == -1, "New name [%s] should not contain a /", newName);
        ChangeSet changeSet = new ChangeSet();
        changeSet.addRenameCi(id, newName);
        this.execute(changeSet);
        EventBusHolder.publish(new CiRenamedEvent(id, newName));
    }

    @Override
    public <T extends ConfigurationItem> void createOrUpdate(T ... entities) {
        ChangeSet changeSet = new ChangeSet();
        changeSet.createOrUpdate(Lists.newArrayList((Object[])entities));
        this.execute(changeSet);
        EventBusHolder.publish(new CisCreatedEvent(Lists.newArrayList(changeSet.getCreateOrUpdateActualCreatedCis())));
        EventBusHolder.publish(new CisUpdatedEvent((List)Lists.newArrayList(changeSet.getCreateOrUpdateActualUpdatedCis())));
    }

    @Override
    public <T extends ConfigurationItem> void update(T ... cis) {
        ChangeSet changeset = new ChangeSet();
        ArrayList updatedCis = Lists.newArrayList((Object[])cis);
        changeset.setUpdateCis(updatedCis);
        this.execute(changeset);
        EventBusHolder.publish(new CisUpdatedEvent((List)updatedCis));
    }

    @Override
    public void delete(String ... ids) {
        ChangeSet changeset = new ChangeSet();
        changeset.setDeleteCiIds(Lists.newArrayList((Object[])ids));
        this.checkReferentialIntegrity(changeset);
        this.execute(changeset);
        EventBusHolder.publish(new CisDeletedEvent(ids));
    }

    @Override
    public void execute(ChangeSet changeset) {
        this.jcrTemplate.execute(new ChangeSetExecutor(changeset, this.passwordEncrypter));
    }

    @Override
    public void checkReferentialIntegrity(ChangeSet changeset) throws ItemInUseException, ItemAlreadyExistsException {
        this.jcrTemplate.execute(new ReferentialIntegrityChecker(changeset, this.passwordEncrypter));
    }

    @Override
    public List<ConfigurationItemData> list(SearchParameters parameters) {
        logger.debug("Listing node IDs with parameters {}.", (Object)parameters);
        Preconditions.checkNotNull((Object)parameters);
        JcrQueryTemplate queryTemplate = new SearchQueryBuilder(parameters).createTemplate();
        return this.list(queryTemplate);
    }

    @Override
    public <T extends ConfigurationItem> List<T> listEntities(SearchParameters parameters) {
        logger.debug("Listing nodes with parameters {}.", (Object)parameters);
        Preconditions.checkNotNull((Object)parameters, (Object)"parameters is null");
        JcrQueryTemplate queryTemplate = new SearchQueryBuilder(parameters).createTemplate();
        return this.listEntities(queryTemplate);
    }

    @Override
    public List<ConfigurationItemData> list(JcrQueryTemplate queryTemplate) {
        Preconditions.checkNotNull((Object)queryTemplate);
        List entities = this.listEntities(queryTemplate);
        return Lists.transform(entities, (Function)new Function<ConfigurationItem, ConfigurationItemData>(){

            public ConfigurationItemData apply(ConfigurationItem input) {
                return new ConfigurationItemData(input.getId(), input.getType());
            }
        });
    }

    @Override
    public <T extends ConfigurationItem> List<T> listEntities(final JcrQueryTemplate queryTemplate) {
        Preconditions.checkNotNull((Object)queryTemplate, (Object)"query is null");
        return (List)this.jcrTemplate.execute(new JcrCallback<List<T>>(){

            @Override
            public List<T> doInJcr(Session session) throws RepositoryException {
                Query query = queryTemplate.createQuery(session);
                QueryResult queryResult = query.execute();
                return JcrRepositoryService.this.getOrderedEntities(session, queryResult);
            }
        });
    }

    private <T extends ConfigurationItem> List<T> getOrderedEntities(Session session, QueryResult queryResult) throws RepositoryException {
        ArrayList items = Lists.newArrayList();
        RowIterator iterator = queryResult.getRows();
        while (iterator.hasNext()) {
            Node node = iterator.nextRow().getNode("ci");
            Object item = NodeReader.read(session, node, null, this.passwordEncrypter);
            items.add(item);
        }
        return items;
    }

    private static class PropertyRef {
        private String owningNode;
        private String property;
        private String uuidOfReferencedNode;

        PropertyRef(String owningNode, String property, String uuidOfReferencedNode) {
            this.owningNode = owningNode;
            this.property = property;
            this.uuidOfReferencedNode = uuidOfReferencedNode;
        }
    }

    private class ReferentialIntegrityChecker
    implements JcrCallback<Object> {
        private final ChangeSet changeset;
        private final PasswordEncrypter passwordEncrypter;

        ReferentialIntegrityChecker(ChangeSet changeset, PasswordEncrypter passwordEncrypter) {
            Preconditions.checkNotNull((Object)changeset);
            this.changeset = changeset;
            this.passwordEncrypter = passwordEncrypter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object doInJcr(Session session) throws RepositoryException {
            this.checkIfAnyOfTheEntitiesToBeCreatedAlreadyExists(session);
            Multimap<String, PropertyRef> deletedEntityRefs = this.findReferencesToDeletedNodes(session);
            ChangeSetExecutor changeSetExecutor = new ChangeSetExecutor(this.changeset, this.passwordEncrypter);
            changeSetExecutor.execute(session, false);
            try {
                this.checkForRemainingReferencesToDeletedNodes(deletedEntityRefs, session);
            }
            finally {
                session.refresh(false);
            }
            return null;
        }

        private void checkIfAnyOfTheEntitiesToBeCreatedAlreadyExists(Session session) throws RepositoryException {
            for (ConfigurationItem entity : this.changeset.getCreateCis()) {
                if (!session.nodeExists(JcrPathHelper.getAbsolutePathFromId(entity.getId()))) continue;
                throw new ItemAlreadyExistsException("Repository entity %s already exists", entity.getId());
            }
        }

        private Multimap<String, PropertyRef> findReferencesToDeletedNodes(Session session) throws RepositoryException {
            ArrayListMultimap deletedEntityRefs = ArrayListMultimap.create();
            for (String deleteNodeId : this.changeset.getDeleteCiIds()) {
                if (!session.nodeExists(JcrPathHelper.getAbsolutePathFromId(deleteNodeId))) continue;
                Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(deleteNodeId));
                PropertyIterator references = node.getReferences();
                while (references.hasNext()) {
                    Property property = references.nextProperty();
                    Node parent = property.getParent();
                    if (this.isParentListCiReference(property, node)) continue;
                    deletedEntityRefs.put((Object)deleteNodeId, (Object)new PropertyRef(parent.getPath(), property.getName(), node.getIdentifier()));
                }
            }
            return deletedEntityRefs;
        }

        private boolean isParentListCiReference(Property referenceProperty, Node nodeToBeDeleted) throws RepositoryException {
            Node owningNode = referenceProperty.getParent();
            if (!nodeToBeDeleted.getParent().getPath().equals(owningNode.getPath())) {
                return false;
            }
            PropertyDescriptor propertyDescriptor = NodeUtils.descriptorOf(referenceProperty);
            return propertyDescriptor.isAsContainment() && propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI;
        }

        private void checkForRemainingReferencesToDeletedNodes(Multimap<String, PropertyRef> deletedEntityRefs, Session session) throws RepositoryException {
            for (String deleteNodeId : deletedEntityRefs.keySet()) {
                for (PropertyRef propertyRef : deletedEntityRefs.get((Object)deleteNodeId)) {
                    Value[] values;
                    Value[] valueArray;
                    Node owningNode;
                    if (!session.nodeExists(propertyRef.owningNode) || !(owningNode = session.getNode(propertyRef.owningNode)).hasProperty(propertyRef.property)) continue;
                    Property property = owningNode.getProperty(propertyRef.property);
                    if (property.isMultiple()) {
                        valueArray = property.getValues();
                    } else {
                        Value[] valueArray2 = new Value[1];
                        valueArray = valueArray2;
                        valueArray2[0] = property.getValue();
                    }
                    for (Value value : values = valueArray) {
                        if (!value.getString().equals(propertyRef.uuidOfReferencedNode)) continue;
                        throw new ItemInUseException("Repository entity %s is still referenced by %s", deleteNodeId, propertyRef.owningNode);
                    }
                }
            }
        }
    }

    private static class SortHierarchyComparator
    implements Comparator<ConfigurationItem> {
        private SortHierarchyComparator() {
        }

        @Override
        public int compare(ConfigurationItem o1, ConfigurationItem o2) {
            int nrSlashes1 = StringUtils.countOccurrencesOf((String)o1.getId(), (String)"/");
            int nrSlashes2 = StringUtils.countOccurrencesOf((String)o2.getId(), (String)"/");
            return nrSlashes1 - nrSlashes2;
        }
    }

    private class ChangeSetExecutor
    implements JcrCallback<Object> {
        public final Function<ConfigurationItem, String> CI_TO_ID_FUNCTION = new Function<ConfigurationItem, String>(){

            public String apply(ConfigurationItem ci) {
                return ci.getId();
            }
        };
        private final ChangeSet changeset;
        private final PasswordEncrypter passwordEncrypter;

        ChangeSetExecutor(ChangeSet changeset, PasswordEncrypter passwordEncrypter) {
            Preconditions.checkNotNull((Object)changeset);
            this.changeset = changeset;
            this.passwordEncrypter = passwordEncrypter;
        }

        @Override
        public Object doInJcr(Session session) throws RepositoryException {
            this.execute(session, true);
            return null;
        }

        public void execute(Session session, boolean autocommit) throws RepositoryException {
            try {
                this.checkpointNodes(this.changeset, session);
                this.createEntities(this.changeset.getCreateCis(), session);
                this.createOrUpdateEntities(this.changeset, session);
                this.updateEntities(this.changeset.getUpdateCis(), session);
                this.moveEntities(this.changeset.getMoveCis(), session);
                this.renameEntities(this.changeset.getRenameCis(), session);
                this.copyEntities(this.changeset.getCopyCis(), session);
                SortedMap<String, VersionHistory> versionHistories = this.deleteEntities(this.changeset.getDeleteCiIds(), session);
                if (autocommit) {
                    this.saveSession(session);
                    this.removeVersionHistories(versionHistories);
                }
            }
            catch (ReferentialIntegrityException exc) {
                throw new ItemInUseException(exc, "Cannot delete configuration items [%s] because one of the configuration items, or one of their children, is still being referenced", Joiner.on((char)',').join(this.changeset.getDeleteCiIds()));
            }
        }

        private void checkpointNodes(ChangeSet changeset, final Session session) throws RepositoryException {
            Iterable updateCisFromCreateOrUpdate = Iterables.filter((Iterable)Lists.transform(changeset.getCreateOrUpdateCis(), this.CI_TO_ID_FUNCTION), (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    try {
                        return session.nodeExists(JcrPathHelper.getAbsolutePathFromId(input));
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeRepositoryException(e.getMessage(), e);
                    }
                }
            });
            List updateCis = Lists.transform(changeset.getUpdateCis(), this.CI_TO_ID_FUNCTION);
            Iterable allCisToCheckpoint = Iterables.concat((Iterable)updateCisFromCreateOrUpdate, (Iterable)updateCis);
            for (String id : allCisToCheckpoint) {
                this.checkpoint(session.getNode(JcrPathHelper.getAbsolutePathFromId(id)), session);
            }
            for (String id : changeset.getDeleteCiIds()) {
                if (!session.nodeExists(JcrPathHelper.getAbsolutePathFromId(id))) continue;
                Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(id));
                this.deepCheckpoint(node, session);
            }
        }

        private void deepCheckpoint(Node node, Session session) throws RepositoryException {
            this.checkpoint(node, session);
            NodeIterator nodes = node.getNodes();
            while (nodes.hasNext()) {
                this.deepCheckpoint(nodes.nextNode(), session);
            }
        }

        private void createOrUpdateEntities(ChangeSet changeset, Session session) throws RepositoryException {
            List<ConfigurationItem> createOrUpdateCis = changeset.getCreateOrUpdateCis();
            ArrayList toBeCreated = Lists.newArrayList();
            ArrayList toBeUpdated = Lists.newArrayList();
            for (ConfigurationItem createOrUpdateCi : createOrUpdateCis) {
                if (!session.nodeExists(JcrPathHelper.getAbsolutePathFromId(createOrUpdateCi.getId()))) {
                    toBeCreated.add(createOrUpdateCi);
                    continue;
                }
                toBeUpdated.add(createOrUpdateCi);
            }
            changeset.getCreateOrUpdateActualCreatedCis().addAll(toBeCreated);
            changeset.getCreateOrUpdateActualUpdatedCis().addAll(toBeUpdated);
            this.createEntities(toBeCreated, session);
            this.updateEntities(toBeUpdated, session);
        }

        private void createEntities(List<ConfigurationItem> entities, Session session) throws RepositoryException {
            if (!entities.isEmpty()) {
                logger.trace("Creating nodes...");
            }
            this.verifyEntitiesMeetCreationPreconditions(entities);
            Collections.sort(entities, new SortHierarchyComparator());
            ArrayList writers = Lists.newArrayList();
            for (ConfigurationItem entity : entities) {
                Node node = this.createNode(entity, session);
                NodeWriter nodeWriter = new NodeWriter(session, entity, node, this.passwordEncrypter);
                nodeWriter.writeBasics();
                writers.add(nodeWriter);
            }
            this.writeEntities(writers);
        }

        private Node createNode(ConfigurationItem entity, Session session) throws RepositoryException {
            this.validateNodeStoredInCorrectPath(entity.getId(), entity.getType(), session);
            logger.debug("Creating node {}.", (Object)entity.getId());
            Node node = session.getRootNode().addNode(entity.getId());
            int index = node.getIndex();
            if (index != 1) {
                node.remove();
                throw new ItemAlreadyExistsException("A Configuration Item with ID [%s] already exists.", entity.getId());
            }
            this.setMixins(entity, node);
            return node;
        }

        private void updateEntities(List<ConfigurationItem> entities, Session session) throws RepositoryException {
            if (!entities.isEmpty()) {
                logger.trace("Updating nodes...");
            }
            List<Node> nodes = this.retrieveNodes(Lists.transform(entities, this.CI_TO_ID_FUNCTION), session);
            for (int i = 0; i < entities.size(); ++i) {
                this.updateNode(entities.get(i), nodes.get(i), session);
            }
        }

        private List<Node> retrieveNodes(Iterable<String> ids, Session session) throws RepositoryException {
            ArrayList nodes = Lists.newArrayList();
            for (String id : ids) {
                Preconditions.checkNotNull((Object)id, (Object)"id is null");
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(id));
                    nodes.add(node);
                }
                catch (PathNotFoundException exc) {
                    throw new NotFoundException("Repository entity [%s] not found", id);
                }
            }
            return nodes;
        }

        private void updateNode(ConfigurationItem entity, Node node, Session session) throws RepositoryException {
            logger.debug("Updating node {}.", (Object)entity.getId());
            new NodeWriter(session, entity, node, this.passwordEncrypter).write();
        }

        private void moveEntities(List<Tuple<String, String>> moveCis, Session session) throws RepositoryException {
            if (!moveCis.isEmpty()) {
                logger.debug("Moving nodes...");
            }
            for (Tuple<String, String> moveCi : moveCis) {
                String newId;
                String toBeMoved = moveCi.getA();
                Checks.checkArgument(!toBeMoved.equals(newId = moveCi.getB()), "Cannot move ci [%s] to same location", newId);
                Type t = JcrRepositoryService.readType(session, toBeMoved);
                JcrRepositoryService.this.checkMoveAllowed(t);
                this.validateNodeStoredInCorrectPath(newId, t, session);
                this.moveNode(JcrPathHelper.getAbsolutePathFromId(toBeMoved), JcrPathHelper.getAbsolutePathFromId(newId), session);
            }
        }

        private void copyEntities(List<Tuple<String, String>> copyCis, Session session) throws RepositoryException {
            if (!copyCis.isEmpty()) {
                logger.debug("Copying nodes...");
            }
            for (Tuple<String, String> copyCi : copyCis) {
                String newId;
                String toBeCopied = copyCi.getA();
                Checks.checkArgument(!toBeCopied.equals(newId = copyCi.getB()), "Cannot copy ci [%s] to same location", newId);
                Checks.checkArgument(!Type.valueOf(Root.class).equals((Object)JcrRepositoryService.readType(session, toBeCopied)), "Cannot copy root node [%s].", toBeCopied);
                JcrRepositoryService.this.checkCopyAllowed(session, toBeCopied, newId);
                this.copyNode(JcrPathHelper.getAbsolutePathFromId(toBeCopied), JcrPathHelper.getAbsolutePathFromId(newId), session);
            }
        }

        private void renameEntities(List<Tuple<String, String>> renameCis, Session session) throws RepositoryException {
            if (!renameCis.isEmpty()) {
                logger.trace("Renaming nodes...");
            }
            for (Tuple<String, String> renameCi : renameCis) {
                String oldId = renameCi.getA();
                String newId = oldId.substring(0, oldId.lastIndexOf(47) + 1) + renameCi.getB();
                Type t = JcrRepositoryService.readType(session, oldId);
                if (t.equals((Object)Type.valueOf(Root.class))) {
                    throw new DeployitException("Cannot rename a core.Root configuration item");
                }
                this.moveNode(JcrPathHelper.getAbsolutePathFromId(oldId), JcrPathHelper.getAbsolutePathFromId(newId), session);
            }
        }

        private void moveNode(String fromId, String toId, Session session) throws RepositoryException {
            logger.debug("Moving/renaming node {} to {}", (Object)fromId, (Object)toId);
            if (session.nodeExists(toId)) {
                throw new ItemAlreadyExistsException("The destination id [%s] exists.", toId);
            }
            session.move(fromId, toId);
        }

        private void copyNode(String fromId, String toId, Session session) throws RepositoryException {
            logger.debug("Copy node {} to {}", (Object)fromId, (Object)toId);
            if (session.nodeExists(toId)) {
                throw new ItemAlreadyExistsException("The destination id [%s] exists.", toId);
            }
            session.getWorkspace().copy(fromId, toId);
        }

        private SortedMap<String, VersionHistory> deleteEntities(List<String> entityIds, Session session) throws RepositoryException {
            if (entityIds.isEmpty()) {
                logger.trace("Deleting nodes...");
            }
            List<Node> nodes = this.retrieveNodesToBeDeleted(entityIds, session);
            TreeMap versionHistories = Maps.newTreeMap();
            for (Node node : nodes) {
                this.retrieveVersionHistories(node, session, versionHistories);
            }
            for (Node node : nodes) {
                logger.debug("Deleting node {}.", (Object)JcrPathHelper.getIdFromAbsolutePath(node.getPath()));
                this.removeParentListCiReferences(node, session);
                node.remove();
            }
            return versionHistories;
        }

        private void removeParentListCiReferences(Node node, Session session) throws RepositoryException {
            Node parent = node.getParent();
            Type t = NodeUtils.typeOf(parent);
            PropertyDescriptor containmentListProperty = NodeUtils.findContainmentListProperty(t, NodeUtils.typeOf(node));
            if (containmentListProperty == null) {
                return;
            }
            Property property = parent.getProperty(containmentListProperty.getName());
            Value[] values = property.getValues();
            ArrayList newValues = Lists.newArrayList();
            for (Value value : values) {
                Node referencedCiNode = NodeUtils.getReferencedCiNode(parent, value, session);
                if (node.getPath().equals(referencedCiNode.getPath())) continue;
                newValues.add(new ReferenceValue(referencedCiNode));
            }
            parent.setProperty(containmentListProperty.getName(), newValues.toArray(new Value[newValues.size()]));
        }

        private List<Node> retrieveNodesToBeDeleted(List<String> ids, Session session) throws RepositoryException {
            ArrayList nodes = Lists.newArrayList();
            for (String id : ids) {
                Preconditions.checkNotNull((Object)id, (Object)"id is null");
                logger.trace("Retrieving node {} to delete it.", (Object)id);
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(id));
                    nodes.add(node);
                }
                catch (PathNotFoundException ignored) {}
            }
            return nodes;
        }

        private void retrieveVersionHistories(Node node, Session session, SortedMap<String, VersionHistory> versionHistories) throws RepositoryException {
            String id = JcrPathHelper.getIdFromAbsolutePath(node.getPath());
            logger.trace("Retrieving version history for node {} to delete it.", (Object)id);
            VersionHistory versionHistory = session.getWorkspace().getVersionManager().getVersionHistory(node.getPath());
            versionHistories.put(id, versionHistory);
            NodeIterator nodes = node.getNodes();
            while (nodes.hasNext()) {
                Node each = nodes.nextNode();
                this.retrieveVersionHistories(each, session, versionHistories);
            }
        }

        private void checkpoint(Node node, Session session) throws RepositoryException {
            logger.trace("Checkpointing node {}.", (Object)JcrPathHelper.getIdFromAbsolutePath(node.getPath()));
            VersionManager versionManager = session.getWorkspace().getVersionManager();
            versionManager.checkpoint(node.getPath());
        }

        private void saveSession(Session session) throws RepositoryException {
            logger.trace("Committing JCR session");
            session.save();
        }

        private void removeVersionHistories(SortedMap<String, VersionHistory> versionHistories) throws RepositoryException {
            logger.trace("Removing version histories that have become obsolete because their corresponding nodes or one of their ancestors was deleted.");
            for (Map.Entry<String, VersionHistory> entry : versionHistories.entrySet()) {
                this.removeVersionHistory(entry.getKey(), entry.getValue());
            }
        }

        private void removeVersionHistory(String id, VersionHistory versionHistory) throws RepositoryException {
            logger.debug("Removing version history for node {}.", (Object)id);
            VersionIterator allVersions = versionHistory.getAllVersions();
            while (allVersions.hasNext()) {
                Version version = allVersions.nextVersion();
                if (version.getName().equals("jcr:rootVersion")) continue;
                logger.trace("Removing version {} from version history for node {}.", (Object)version.getName(), (Object)id);
                versionHistory.removeVersion(version.getName());
            }
        }

        private void verifyEntitiesMeetCreationPreconditions(List<ConfigurationItem> cis) {
            for (int i = 0; i < cis.size(); ++i) {
                ConfigurationItem ci = cis.get(i);
                Preconditions.checkNotNull((Object)ci, (String)"ci at index %s is null.", (Object[])new Object[]{i});
                Preconditions.checkNotNull((Object)ci.getId(), (String)"ci at index %s has null id.", (Object[])new Object[]{i});
                if (!(ci instanceof SourceArtifact)) continue;
                Checks.checkArgument(((SourceArtifact)ci).getFile() != null, "Artifact %s should have file", ci.getId());
            }
        }

        private void validateNodeStoredInCorrectPath(String id, Type type, Session session) throws RepositoryException {
            Checks.checkArgument(DescriptorRegistry.exists((Type)type), "Unknown configuration item type %s", type);
            Descriptor desc = DescriptorRegistry.getDescriptor((Type)type);
            String[] pathElements = id.split("/");
            if (desc.isAssignableTo(Directory.class)) {
                Checks.checkArgument(pathElements.length >= 2, "A core.Directory must be stored under a Root node, not under %s.", id);
                for (Metadata.ConfigurationItemRoot configurationItemRoot : Metadata.ConfigurationItemRoot.values()) {
                    if (!configurationItemRoot.getRootNodeName().equals(pathElements[0])) continue;
                    return;
                }
                throw new Checks.IncorrectArgumentException("A core.Directory must be stured under a valid Root node, not under %s.", id);
            }
            if (desc.getRoot() == Metadata.ConfigurationItemRoot.NESTED) {
                Checks.checkArgument(pathElements.length >= 3, "Configuration item of type %s cannot be stored at %s. It should be stored under a valid parent node", type, id);
                String parentId = id.substring(0, id.lastIndexOf(47));
                Node parentNode = session.getNode(JcrPathHelper.getAbsolutePathFromId(parentId));
                Checks.checkArgument(parentNode != null, "Configuration item of type %s cannot be stored at %s. The parent does not exist", type, id);
                Checks.checkArgument(parentNode.isNodeType("deployit:configurationItem"), "Configuration item of type %s cannot be stored at %s. The parent is not a configuration item", type, id);
                String parentTypeName = parentNode.getProperty("$configuration.item.type").getString();
                Descriptor parentDescriptor = DescriptorRegistry.getDescriptor((String)parentTypeName);
                for (PropertyDescriptor aPD : desc.getPropertyDescriptors()) {
                    if (aPD.getKind() != PropertyKind.CI || !aPD.isAsContainment() || !parentDescriptor.isAssignableTo(aPD.getReferencedType())) continue;
                    return;
                }
                for (PropertyDescriptor aPD : parentDescriptor.getPropertyDescriptors()) {
                    if (!EnumSet.of(PropertyKind.SET_OF_CI, PropertyKind.LIST_OF_CI).contains(aPD.getKind()) || !aPD.isAsContainment() || !desc.isAssignableTo(aPD.getReferencedType())) continue;
                    return;
                }
                throw new Checks.IncorrectArgumentException("Configuration item of type %s cannot be stored at %s. The parent cannot contain configuration items of this type", type, id);
            }
            Checks.checkArgument(pathElements[0].equals(desc.getRoot().getRootNodeName()), "Configuration item of type %s cannot be stored at %s. It should be stored under %s", type, id, desc.getRoot().getRootNodeName());
        }

        private void setMixins(ConfigurationItem entity, Node node) throws RepositoryException {
            if (entity instanceof Artifact) {
                node.addMixin("deployit:artifact");
                node.addMixin("deployit:configurationItem");
            } else {
                node.addMixin("deployit:configurationItem");
            }
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}referenceable");
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        }

        private void writeEntities(List<NodeWriter> writers) throws RepositoryException {
            for (NodeWriter writer : writers) {
                writer.write();
            }
        }
    }
}

