/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter;
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.rest.FormatFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.ws.rs.core.MediaType;

public abstract class AbstractConfigurationItemReaderWriter {
    protected static final String LEVEL = "level";
    protected FormatFactory formats = new FormatFactory();
    protected Repository repository;

    public AbstractConfigurationItemReaderWriter(RepositoryFactory repositoryFactory) {
        this.repository = repositoryFactory.create();
    }

    protected ConfigurationItemConverter createConverter() {
        return new PasswordEncryptingCiConverter();
    }

    protected int getCiRefsFromLevel() {
        int level = 0;
        Object levelParam = RequestLocal.getMap().get(LEVEL);
        if (levelParam != null) {
            level = (Integer)levelParam;
        }
        return level;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        return ConfigurationItem.class.isAssignableFrom(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadable(type, genericType, annotations, mediaType);
    }
}

