/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.rest.api.RepositoryResource;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.repository.core.Directory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.stereotype.Controller;

@Path(value="/repository")
@Consumes(value={"application/json", "application/xml"})
@Produces(value={"application/json", "application/xml"})
@Controller
public class ExtendedRepositoryService
extends RepositoryResource {
    private static final String LEVEL = "level";
    private static final Type DIRECTORY = Type.valueOf(Directory.class);

    @GET
    @Path(value="tree/{ID:.*?}")
    public ConfigurationItem read(@PathParam(value="ID") String id, @QueryParam(value="level") Integer level) {
        this.setCiRefsFromLevel(level);
        return this.read(id);
    }

    @POST
    @Path(value="tree")
    public List<ConfigurationItem> read(List<String> ids, @QueryParam(value="level") Integer level) {
        this.setCiRefsFromLevel(level);
        return this.read(ids);
    }

    @GET
    @Path(value="export")
    public List<ConfigurationItem> export() {
        return this.export(this.listAllIds());
    }

    @GET
    @Path(value="export/{ID:.*?}")
    public List<ConfigurationItem> export(@PathParam(value="ID") String id) {
        ArrayList ids = Lists.newArrayList((Object[])new ConfigurationItemId[]{new ConfigurationItemId(id, null)});
        this.addNested(id, ids);
        return this.export(ids);
    }

    private List<ConfigurationItem> export(List<ConfigurationItemId> ids) {
        List<ConfigurationItem> cis = this.read(ExtendedRepositoryService.toString(ids), null);
        return ExtendedRepositoryService.removeTokens(cis);
    }

    private List<ConfigurationItemId> listAllIds() {
        ArrayList ids = Lists.newArrayList();
        for (Metadata.ConfigurationItemRoot root : Metadata.ConfigurationItemRoot.values()) {
            if (root.getRootNodeName() == null) continue;
            this.addNested(root.getRootNodeName(), ids);
        }
        return ids;
    }

    private void addNested(String parent, List<ConfigurationItemId> foundIds) {
        List children = this.query(null, parent, null, null, null, 0L, -1L);
        for (ConfigurationItemId child : children) {
            foundIds.add(child);
            if (!child.getType().equals((Object)DIRECTORY)) continue;
            this.addNested(child.getId(), foundIds);
        }
    }

    private static <T extends Collection<ConfigurationItem>> T removeTokens(T cis) {
        for (ConfigurationItem ci : cis) {
            ExtendedRepositoryService.removeToken(ci);
            for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
                PropertyKind kind = property.getKind();
                if (kind != PropertyKind.SET_OF_CI && kind != PropertyKind.LIST_OF_CI) continue;
                ExtendedRepositoryService.removeTokens((Collection)property.get(ci));
            }
        }
        return cis;
    }

    private static void removeToken(ConfigurationItem ci) {
        if (ci instanceof BaseConfigurationItem) {
            ((BaseConfigurationItem)ci).set$token(null);
        }
    }

    private static List<String> toString(List<ConfigurationItemId> cis) {
        ArrayList<String> ids = new ArrayList<String>();
        for (ConfigurationItemId ci : cis) {
            ids.add(ci.getId());
        }
        return ids;
    }

    public void setCiRefsFromLevel(Integer level) {
        level = (Integer)Objects.firstNonNull((Object)level, (Object)Integer.MAX_VALUE);
        RequestLocal.getMap().put(LEVEL, level);
    }
}

