/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.scheduler;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.springframework.stereotype.Component;

@Component
public class Scheduler {
    public static final int POOL_CAPACITY = 25;
    private ListeningScheduledExecutorService executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(25));
    private Map<Runnable, ScheduledFuture<?>> futures = Maps.newHashMap();

    public synchronized void scheduleAtFixedRate(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (this.futures.containsKey(command)) {
            throw new IllegalStateException("Can't schedule multiple times the same command");
        }
        ScheduledFuture scheduledFuture = this.executor.scheduleAtFixedRate(command, initialDelay, delay, unit);
        this.futures.put(command, scheduledFuture);
    }

    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    public <T> ListenableFuture<T> submit(Callable<T> callable) {
        return this.executor.submit(callable);
    }

    public synchronized void cancel(Runnable command) {
        ScheduledFuture<?> future = this.futures.remove(command);
        if (null != future) {
            future.cancel(false);
        }
    }

    @PreDestroy
    public void shutdown() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

