/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.DeployitTask;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.ReleaseActivitiesFormatter;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.views.TaskFullView;
import java.util.ArrayList;
import java.util.List;

public class TaskFieldsComparator {
    private Task original;
    private TaskFullView updated;

    public TaskFieldsComparator(Task original, TaskFullView updated) {
        this.original = original;
        this.updated = updated;
    }

    public List<ActivityLogEntry> getLogs() {
        ArrayList logEntries = Lists.newArrayList();
        this.addTasksLogs(logEntries);
        if (this.original instanceof DeployitTask) {
            this.addDeployitTaskLogs(logEntries);
        } else if (this.original instanceof NotificationTask) {
            this.addNotificationTaskLogs(logEntries);
        } else if (this.original instanceof ScriptTask) {
            this.addScriptTaskLogs(logEntries);
        } else if (this.original instanceof CustomScriptTask) {
            this.addCustomScriptTaskLogs(logEntries);
        }
        return logEntries;
    }

    private void addTasksLogs(List<ActivityLogEntry> logEntries) {
        if (!Objects.equal((Object)this.original.getTitle(), (Object)this.updated.getTitle())) {
            logEntries.add(ReleaseActivities.TASK_TITLE_UPDATED.create(this.original.getTitle(), this.original.getTitle(), this.updated.getTitle()));
        }
        if (!Objects.equal((Object)this.original.getDescription(), (Object)this.updated.getDescription())) {
            logEntries.add(ReleaseActivities.TASK_DESCRIPTION_UPDATED.create(this.updated.getTitle(), this.original.getDescription(), this.updated.getDescription()));
        }
        if (!Objects.equal((Object)this.original.getOwner(), (Object)this.updated.getOwner())) {
            logEntries.add(ReleaseActivities.TASK_OWNER_UPDATED.create(this.updated.getTitle(), ReleaseActivitiesFormatter.quoteAssignee(this.original.getOwner()), ReleaseActivitiesFormatter.quoteAssignee(this.updated.getOwner())));
        }
        if (!Objects.equal((Object)this.original.getTeam(), (Object)this.updated.getTeam())) {
            logEntries.add(ReleaseActivities.TASK_TASK_TEAM_UPDATED.create(this.updated.getTitle(), ReleaseActivitiesFormatter.quoteAssignee(this.original.getTeam()), ReleaseActivitiesFormatter.quoteAssignee(this.updated.getTeam())));
        }
        if (!Objects.equal((Object)this.original.getDueDate(), (Object)this.updated.getDueDate())) {
            logEntries.add(ReleaseActivities.TASK_DUE_DATE_UPDATED.create(this.updated.getTitle(), ReleaseActivitiesFormatter.formatDate(this.original.getDueDate()), ReleaseActivitiesFormatter.formatDate(this.updated.getDueDate())));
        }
        if (!Objects.equal((Object)this.original.getScheduledStartDate(), (Object)this.updated.getScheduledStartDate())) {
            logEntries.add(ReleaseActivities.TASK_SCHEDULED_START_DATE_UPDATED.create(this.updated.getTitle(), ReleaseActivitiesFormatter.formatDate(this.original.getScheduledStartDate()), ReleaseActivitiesFormatter.formatDate(this.updated.getScheduledStartDate())));
        }
        if (!Objects.equal((Object)((Object)this.original.getFlagStatus()), (Object)((Object)this.updated.getFlag().getStatus()))) {
            logEntries.add(ReleaseActivities.TASK_FLAG_STATUS_UPDATED.create(this.updated.getTitle(), this.original.getFlagStatus().name(), this.updated.getFlag().getStatus().name()));
        }
        if (!Objects.equal((Object)this.original.getFlagComment(), (Object)this.updated.getFlag().getComment())) {
            logEntries.add(ReleaseActivities.TASK_FLAG_COMMENT_UPDATED.create(this.updated.getTitle(), this.original.getFlagComment(), this.updated.getFlag().getComment()));
        }
    }

    private void addDeployitTaskLogs(List<ActivityLogEntry> logEntries) {
        DeployitTask deployitTask = (DeployitTask)this.original;
        if (!Objects.equal((Object)deployitTask.getServer(), (Object)this.updated.getServer())) {
            logEntries.add(ReleaseActivities.TASK_DEPLOYIT_SERVER_UPDATED.create(this.updated.getTitle(), deployitTask.getServer(), this.updated.getServer()));
        }
        if (!Objects.equal((Object)deployitTask.getDeploymentPackage(), (Object)this.updated.getDeploymentPackage())) {
            logEntries.add(ReleaseActivities.TASK_DEPLOYIT_PACKAGE_UPDATED.create(this.updated.getTitle(), deployitTask.getDeploymentPackage(), this.updated.getDeploymentPackage()));
        }
        if (!Objects.equal((Object)deployitTask.getEnvironment(), (Object)this.updated.getEnvironment())) {
            logEntries.add(ReleaseActivities.TASK_DEPLOYIT_ENVIRONMENT_UPDATED.create(this.updated.getTitle(), deployitTask.getEnvironment(), this.updated.getEnvironment()));
        }
        if (!Objects.equal((Object)deployitTask.getUsername(), (Object)this.updated.getUsername())) {
            logEntries.add(ReleaseActivities.TASK_DEPLOYIT_USERNAME_UPDATED.create(this.updated.getTitle(), deployitTask.getUsername(), this.updated.getUsername()));
        }
        if (!Objects.equal((Object)deployitTask.getPassword(), (Object)this.updated.getPassword())) {
            logEntries.add(ReleaseActivities.TASK_DEPLOYIT_PASSWORD_UPDATED.create(this.updated.getTitle()));
        }
    }

    private void addNotificationTaskLogs(List<ActivityLogEntry> logEntries) {
        NotificationTask notificationTask = (NotificationTask)this.original;
        if (!Objects.equal(notificationTask.getAddresses(), this.updated.getAddresses())) {
            logEntries.add(ReleaseActivities.TASK_NOTIFICATION_ADDRESSES_UPDATED.create(this.updated.getTitle(), notificationTask.getAddresses() != null ? Sets.newHashSet(notificationTask.getAddresses()) : null, this.updated.getAddresses()));
        }
        if (!Objects.equal((Object)notificationTask.getSubject(), (Object)this.updated.getSubject())) {
            logEntries.add(ReleaseActivities.TASK_NOTIFICATION_SUBJECT_UPDATED.create(this.updated.getTitle(), notificationTask.getSubject(), this.updated.getSubject()));
        }
        if (!Objects.equal((Object)notificationTask.getBody(), (Object)this.updated.getBody())) {
            logEntries.add(ReleaseActivities.TASK_NOTIFICATION_BODY_UPDATED.create(this.updated.getTitle(), notificationTask.getBody(), this.updated.getBody()));
        }
    }

    private void addScriptTaskLogs(List<ActivityLogEntry> logEntries) {
        ScriptTask scriptTask = (ScriptTask)this.original;
        if (!Objects.equal((Object)scriptTask.getScript(), (Object)this.updated.getScript())) {
            logEntries.add(ReleaseActivities.TASK_SCRIPT_UPDATED.create(this.updated.getTitle(), scriptTask.getScript(), this.updated.getScript()));
        }
    }

    private void addCustomScriptTaskLogs(List<ActivityLogEntry> logEntries) {
        String propertyName;
        CustomScriptTask customScriptTask = (CustomScriptTask)this.original;
        PythonScript pythonScript = customScriptTask.getPythonScript();
        for (PropertyDescriptor propertyDescriptor : pythonScript.getInputProperties()) {
            propertyName = propertyDescriptor.getName();
            if (propertyDescriptor.isPassword()) {
                this.comparePasswordProperty(logEntries, pythonScript, propertyDescriptor, propertyName);
                continue;
            }
            this.compareProperty(logEntries, pythonScript, propertyDescriptor, propertyName);
        }
        for (PropertyDescriptor propertyDescriptor : pythonScript.getOutputProperties()) {
            String newValue;
            propertyName = propertyDescriptor.getName();
            String oldValue = (String)pythonScript.getProperty(propertyName);
            if (Objects.equal((Object)oldValue, (Object)(newValue = this.updated.getOutputProperties().get(propertyName)))) continue;
            logEntries.add(ReleaseActivities.TASK_OUTPUT_PROPERTIES_UPDATED.create(propertyDescriptor.getLabel(), this.updated.getTitle(), oldValue, newValue));
        }
    }

    private void comparePasswordProperty(List<ActivityLogEntry> logEntries, PythonScript pythonScript, PropertyDescriptor propertyDescriptor, String propertyName) {
        Object newValue;
        Object oldValue = pythonScript.getProperty(propertyName);
        if (!Objects.equal((Object)oldValue, (Object)(newValue = this.updated.getInputProperties().get(propertyName)))) {
            logEntries.add(ReleaseActivities.TASK_INPUT_PROPERTY_PASSWORD_UPDATED.create(propertyDescriptor.getLabel(), this.updated.getTitle()));
        }
    }

    private void compareProperty(List<ActivityLogEntry> logEntries, PythonScript pythonScript, PropertyDescriptor propertyDescriptor, String propertyName) {
        Object newValue;
        Object oldValue = pythonScript.getProperty(propertyName);
        if (!Objects.equal((Object)oldValue, (Object)(newValue = this.updated.getInputProperties().get(propertyName)))) {
            logEntries.add(ReleaseActivities.TASK_INPUT_PROPERTY_UPDATED.create(propertyDescriptor.getLabel(), this.updated.getTitle(), oldValue, newValue));
        }
    }
}

